require "./lib/apocrodentia"
require "colorize"
require "test/unit"
class TestInhabitable < BaseBehaviorTestCase

  def setup
    super
    @inhabitable = GameScene.new    
    @inhabitant = Traveller.new
    @test_data = {}


    test_init_gauges

  end



  def test_inhabitables_give_off_perspective_change_to_enterers
    evt = AR::Events::ARObjectEnteredInhabitableEvent.new ({enterer: @inhabitant, inhabitable: @inhabitable})    

    results = evt.resolve!
    result = results.select{|e| e.class == AR::Events::PerceptionAccountChangedEvent and e.discoverable== @inhabitable and e.perceiver == @inhabitant}.first
    assert_not_nil result
    assert_equal @inhabitant.perception_lvl, result.change
  end


  
end
