#stuff to generate files....
class String
  def underscore
    self.gsub(/::/, '/').
      gsub(/([A-Z]+)([A-Z][a-z])/,'\1_\2').
      gsub(/([a-z\d])([A-Z])/,'\1_\2').
      tr("-", "_").
      downcase
  end
end

module Generator
  def generate_ar_object ar_object_name

    new_ar_object_classname = backup = ar_object_name

    new_ar_object_fname = backup.underscore
    ar_object_file = File
    .open("generate/template/ar_object.rb")
    .read
    .gsub(/AR_OBJECT_NAME/,new_ar_object_classname)

    #ADD NEW ar_object FILE
    f = File.open("lib/apocrodentia/game/ar_object/#{new_ar_object_fname}.rb", "w")
    f.write ar_object_file
    f.close

    #require file in manifest
    manifest= File.open("lib/apocrodentia/game/ar_object.rb", "a")
    manifest.write "\nrequire_relative \"ar_object/#{new_ar_object_fname}\""
    manifest.close
  end

  def generate_behavior behavior_name

    new_behavior_classname = backup = behavior_name

    new_behavior_fname = backup.underscore
    behavior_file = File
    .open("generate/template/behavior.rb")
    .read
    .gsub(/BEHAVIOR_NAME/,new_behavior_classname)

    #add new behavior file
    f = File.open("lib/apocrodentia/game/behavior/#{new_behavior_fname}.rb", "w")
    f.write behavior_file
    f.close

    #add new test file
    test_file = File.open("generate/template/test_behavior.rb")
    .read
    .gsub(/BEHAVIOR_NAME/,new_behavior_classname) 

    f = File.open("tests/behavior/test_#{new_behavior_fname}.rb", "w")
    f.write test_file
    f.close

    #append require for new file to the behavior  manifest
    manifest= File.open("lib/apocrodentia/game/behavior.rb", "a")
    manifest.write "\nrequire_relative \"behavior/#{new_behavior_fname}\""
    manifest.close

  end

  def generate_event event_name


    new_event_classname = backup = event_name 

    new_event_fname = backup.underscore
    event_file = File
    .open("generate/template/event.rb")
    .read
    .gsub(/EVENT_NAME/,new_event_classname)

    #ADD NEW EVENT FILE
    f = File.open("lib/apocrodentia/events/event/#{new_event_fname}.rb", "w")
    f.write event_file
    f.close

    #add new test file
    #test_file = File.open("generate/template/test_event.rb")
    #.read
    #.gsub(/EVENT_NAME/,new_event_classname) 

    #f = File.open("tests/test_#{new_event_fname}.rb", "w")
    #f.write test_file
    #f.close

    #append require for new file to the event  manifest
    manifest= File.open("lib/apocrodentia/events/event.rb", "a")
    manifest.write "\nrequire_relative \"event/#{new_event_fname}\""
    manifest.close
  end

end


