module AR::Game::ItemBehavior 

  def owner
    self.world.find owner_id
  end

  def owner=(ar_object)
    if ar_object.nil?
      self.owner_id = nil 
      return
    end
    self.owner_id = ar_object.id
  end
  
  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :owner_id
  end

  def self.owner_unset_parent_set_on_removed
    AR::Events::Resolution.new event_class: AR::Events::ItemRemovedFromInventory, as: "item" do |e|
      item = e.item
      owner = e.inventory_owner
      item.parent = owner.parent
      item.parent.add_inhabitant(item, "on the ground") unless item.parent.nil?
      item.owner = nil
      nil
    end
  end
  def self.owner_set_parent_unset_on_added
    AR::Events::Resolution.new event_class: AR::Events::ItemAddedToInventory, as: "item" do |e|
      item = e.item
      owner = e.inventory_owner
      item.owner = owner
      item.parent.rem_inhabitant(item) unless item.parent.nil?
      item.parent = nil
      nil
    end
  end

  def self.extended ar_object
    self.init ar_object
    #add to object's event subscriptions and resolutions here...
    ar_object.resolutions << owner_unset_parent_set_on_removed
    ar_object.resolutions << owner_set_parent_unset_on_added
  end 


end
