module AR::Game::EmoteBehavior 
=begin  
  attr_accessor :emote_stories
  attr_accessor :told_emotes
  attr_accessor :mood_change_stories
  attr_accessor :current_mood

  #...initialize them here
  def self.init ar_object 
    told_emotes = []
    current_mood = nil
  end

  def self.extended ar_object
    self.init ar_object
    #add to object's event subscriptions and resolutions here...
  end 


  def express_emote
    return "" if current_mood.nil?
    next_emote = (emote_stories[current_mood] - told_emotes).sample
    told_emotes ||= []
    told_emotes << next_emote
    emote_stories[current_mood].delete next_emote
    reset_emote_state!  if emote_stories[current_mood].empty?
    next_emote
  end

  def self.reset_told_emotes_and_change_state_on_mood_change
    AR::Game::Resolution.new event_class: AR::Events::MoodChangeEvent, as: "emoter" do |e|
      emoter = e.emoter
      new_mood = e.new_mood
      emoter.reset_emote_state! 
      emoter.current_mood = new_mood
      nil
    end
  end

  def reset_emote_state!
    emote_stories[current_mood] += told_emotes
    told_stories = []
  end
=end
end
