module AR
  module Game

    class Forest05GateToCourtyard < PhysicalObject
      def initialize id=nil
        super 
        self.noun = "wooden gate"
        add_behavior AR::Game::Gateway
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end
     
      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "It's a gate with a metal latch strewn together with some rustic cord, built out of roughly lumbered logs. It's set into a tight stone wall."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "To the east, the cobblestone path leads up to a wooden gate."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "The gate creaks open, and you step through to a courtyard."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end



  end
end
