class AR::Events::DialogMenuPresented < AR::Events::Event
  attr_accessor :dialog_node

  def initialize params
    super params
    self.dialog_node = params[:dialog_node]
  end 


  def resolve!
    m = AR::Game::Menu.new
    m.name = "What do you say?"
    npc=dialog_node.npc    
    dialog_node.limbs.each_with_index do |l,i|
      i += 1
      opt=AR::Game::Option.new do |o|
        o.ids = [(i).to_s] 
        o.usage = "#{i})"
        o.description = "\"#{l.player_speech_event.speech}\""  
        o.chosen = Proc.new do
          npc.create AR::Events::DialogNodeActivatedEvent, dialog_node: l, npc: npc
        end
      end
      m.options.push opt
    end
    m.present
  end 

end
