require "io/console"
module KeySensor

  # Check if Win32API is accessible or not
  Use_stty =
    begin
      require 'Win32API'
      KBhit = Win32API.new('crtdll', '_kbhit', [ ], 'I')
      Getch = Win32API.new('crtdll', '_getch', [ ], 'L')
      false
    rescue LoadError
      # Use Unix way
      true
    end

  # Return the ASCII code of the last key pressed, or nil if none
  #
  # Return::
  # * _Integer_: ASCII code of the last key pressed, or nil if none
  def self.get_key
    if Use_stty
      char = nil
      begin
        system('stty', 'raw', '-echo') # => Raw mode, no echo
        char = (STDIN.read_nonblock(1).ord rescue nil)
      ensure
        system('stty', '-raw', 'echo') # => Reset terminal mode
      end
      return char
    else
      return KBhit.Call.zero? ? nil : Getch.Call
    end
  end

end
