module AR::Game::ActorBehavior 
  attr_accessor :last_action_this_tick
  attr_accessor :last_action
  
  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :initiative, :action_points, :ownership
    ar_object.initiative = 0
    ar_object.action_points = 1
    ar_object.last_action = nil
    ar_object.last_action_this_tick = nil
    ar_object.ownership = "its"
  end



  def self.extended ar_object
    self.init ar_object
    ar_object.subscriptions << self.attach_to_clock_tick(ar_object)
  end 


  def self.attach_to_clock_tick ar_object
    AR::Events::Subscription.new event_class: AR::Events::ClockTickEvent do |e|

      #raise "Object #{ar_object} should not be here"   if ar_object.dead? 
      ar_object.initiative = rand(1..100)
      ar_object.action_points =  2

      e.actors << ar_object 
    end
  end   


end
