// Перевод на русский: Oreolek, 2010
// ---------------------------------------------------------------------------
// Отредактируйте этот файл, чтобы описать вашу игру. Он должен иметь не
// менее четырёх разделов данных: undum.game.situations, undum.game.start,
// undum.game.qualities, и undum.game.init.
// ---------------------------------------------------------------------------

/* Уникальный идентификатор вашей игры. Он никогда не отображается. 
 * Я использую UUID, но вы можеет использовать всё что гарантированно
 * уникально (URL, которым вы владеете, или вариацию вашего адреса 
 * e-mail, например).*/
undum.game.id = "349baf43-9ade-49a8-86d0-24e3de3ce072";

undum.game.version = "1.0";

/* Ситуации, в которых может быть игра. Каждая имеет уникальный ID. */
undum.game.situations = {
    start: new undum.SimpleSituation(
        "<h1>Знакомство с Undum</h1>\
        <img src='media/games/tutorial/woodcut1.png' class='float_right'>\
        <p>Добро пожаловать в обучающую игру по Undum. Undum - это инструмент для написания\
        гипертекстовой интерактивной литературы. Он обладает некоторыми уникальными возможностями\
        и визуальным дизайном, который поддерживает повествующие игры.</p>\
        \
        <p>Гипертекстовая интерактивная литература - это цифровой эквивалент книгам\
        Choose Your Own Adventure (CYOA), которые были популярны в\
        1980х. История рассказывается кусочками, и вы выбираете из нескольких \
        вариантов, чтобы продвинуть её дальше. Тем не менее, в отличие от книжной формы, цифровая\
        версия даёт вам намного больше гибкости, чтобы рассказать богатые истории\
        и представить более интересные элементы игры.</p>\
        \
        <p class='transient'>А сейчас давайте продолжим обучение.\
        <a href='rooms'>Нажмите на эту ссылку</a>, чтобы продвинуться дальше.</p>"
    ),
    // Для разнообразия, здесь мы задаём ситуацию, используя высокоуровневый тип Situation.
    // Это прекрасный подход, чтобы сгенерировать текст, просто найдя его в HTML документе.
    // Для статичного текста в этом больше смысла, чем записывать его просто так.
    rooms: new undum.Situation({
        enter: function(character, system, from) {
            system.write($("#s_rooms").html());
        }
    }),
    todo: new undum.SimpleSituation(
        "<p>В ситуации может произойти две вещи. Либо персонаж\
        <a href='links'>покидает</a> ситуацию и входит в другую, либо\
        он выполняет некоторое <a href='./do-something'>действие</a>. Действия могут\
        выполнять некоторые вычисления, могут выводить какие-нибудь результаты, но\
        все они возвращают персонажа обратно в ту же ситуацию.</p>\
        \
        <p>Когда вы создаёте свою игру, используйте ситуации, чтобы отразить\
        изменения в том, что може сделать персонаж. Так, вы можете изменить ситуацию если персонаж\
        тянет рычаг, чтобы открыть люк, например. Действия\
        предназначены для ситуаций, где персонаж может изучать вещи более пристально\
        , а может быть улучшить свою магию, выпив зелья.\
        Это вещи, которые не влияют на мир вокруг них.</p>\
        \
        <p>Ситуации генерируют содержимое, когда в них входят (метод <em>enter</em>),\
        выходят (<em>exit</em>), и когда они получают действие (<em>act</em>).\
        Вы можете написать код, который будет генерировать текст любым удобным вам способом, \
        чтобы отображаемое содержимое могло быть полностью динамичным, \
        принимая во внимание текущее состояние персонажа.</p><p>\
        Содержимое - это обычный HTML, поэтому вы можете использовать все HTML теги, чтобы выделить\
        что-то в тексте или добавить иллюстрации.Это даёт вам огромную гибкость. Например, так как Undum\
        нацелен на HTML 5, вы можете использовать теги <em>audio</em> или\
        <em>video</em>, чтобы вставить музыкальное или видео оформление.</p>\
        \
        <p class='transient'>Убедитесь в том, что вы выполнили действие выше,\
        а затем <a href='links'>продолжайте</a>.</p>",
        {
            actions: {
                'do-something': "<p>Браво, вы выполнили действие.\
                                 Заметьте, что ссылки для этой ситуации всё ещё активны.\
                                 Это означает,что вы можете нажать на них, чтобы\
                                 выполнить действие ещё раз.</p>"
            }
        }
    ),
    links: new undum.SimpleSituation(
        "<h1>Смена наполнения</h1>\
        <p>Между каждым кусочком нового текста Undum вставляет отчётливую линию\
        на полях. Она позволяет вам быстро увидеть всё, что было выдано\
        в качестве результата вашего последнего клика.\
        Это очень удобно для маленьких устройств, или когда появилось\
        очень много текста. Также окно перемещается таким образом, что начало\
        нового содержимого приходится настолько близко к верхнему краю окна, насколько возможно.\
        Это также сделано для того, чтобы помочь вам читать натуральнее.</p>\
        \
        <p>Если вы внимательно смотрели, вы заметили, что некоторые части\
        текста исчезали, когда вы выходили из ситуаций. Это не баг!\
        Одна из целей Undum - это дать геймдизайнерам возможность сделать\
        запись игры связным рассказом.\
        Тем не менее, вам часто нужны кусочки текста, которые ничего не делают, но просто\
        предлагают читателю выбор.\
        Для этого Undum определяет специальный CSS класс для добавления в ващ HTML\
        (помните, сгенерированное содержимое - это просто HTML). Этот класс называется <em>transient</em>\
        и может быть применён к параграфам, div'ам или просто\
        span'ам<span class='transient'> (как вот этот)</span>.</p>\
        \
        <p>также вы могли заметить, что, когда вы перемещаетесь в другую ситуацию, все ссылки\
        в предыдущей превращаются в обычный текст. Это сделано для того, чтобы не дать вам\
        отступить и попробовать предыдущие варианты ответа, когда вы уже выбрали один из них.\
        В других H-IF системах это делается при помощи полной очистки предыдущих страниц.\
        Но это не позволяет вам вернуться и перечитать вашу историю.</p>\
        \
        <p class='transient'>Давайте узнаем больше о ссылках и посмотри, как <a href='sticky'>изменить</a> это поведение.</p>"
    ),
    sticky: new undum.SimpleSituation(
        "<h1>Ссылки</h1>\
        <p>В undum существует три типа ссылок. Мы уже видели первые два:\
        ссылки смены ситцаций и ссылки, вызывающие действие. Когда вы\
        включаете ссылку в ваш текст, undum распознаёт её и оформляет\
        подобающим образом. Если вы создаёте ссылку с атрибутом HTML <em>href</em>,\
        содержащим только имя ('зал', например), то она отправит персонажа\
        в ситуацию с этим именем. Ссылки с двумя компонентами ('зал/посмотреть-картину')\
        отправят персонажа в новую ситуацию <em>и тогда</em> вызовут действие в\
        текущей ситуации. Вы можете заменить имя ситуации точкой ('./посмотреть-картину'). В\
        любом случае, если персонаж уже находится в этой ситуации, то её метод <em>enter</em>\
        ещё раз вызываться не будет.</p>\
        \
        <img src='media/games/tutorial/woodcut2.png' class='float_left'>\
        <p>Наконец, третий тип ссылок - это обычная гиперссылка. Если ваша\
        ссылка не состоит из одного элемента или пары элементов, как описано выше, то\
        Undum догадается, что вы имели в виду обычную гиперссылку. Например, \
        <a href='http://www.bbc.co.uk/russian/' class='sticky'>как в этом случае.</a>\
        Если ваша ссылка всё-таки <em>выглядит</em> как ссылка Undum, то вы\
        всё ещё можете заставить Undum не интерпретировать её как ситуацию или действие, добавив\
        CSS класс <em>raw</em> к тегу HTML <em>a.</em>\
        Ссылкам, которые не относятся к классу <em>raw</em>, но угадываются как\
        не-Undum, класс <em>raw</em> добавится автоматически перед отображением.\
        Это позволит вам выделить внешние ссылки особым образом, как мы сделали в этой игре.</p>\
        \
        <p>В последней ситуации я сказал, что вы можете остановить ссылки от превращения в обычный текст, когда\
        вы меняете ситуацию. Это делается при помощи другого класса\
        CSS: <em>sticky</em>. Когда вы\
        <a href='oneshot'>покинете эту ситуацию</a>, вы заметите, что внешняя ссылка осталась активной.\
        Это позволяет вам предлагать ссылки, которые останутся рабочими в течение всего рассказа,\
        например, ссылка заклинания телепортации домой.</p>"
    ),
    oneshot: new undum.SimpleSituation(
        "<p>Ещё одна последняя настройка ссылок. Если вы назначите ссылке CSS класс\
        <em>once</em>, то она исчезнет после нажатия. Это используется \
        <a href='./one-time-action' class='once'>(проверьте сами)</a> для\
        действий, которые вы хотите сделать однократными. Нет смысла использовать\
        'once' на ссылках ситуаций, потому что они всё равно превратятся в текст, как только вы на них нажмёте\
        ( конечно, если они не помечены как <em>sticky</em>).</p><p>Однократные ссылки полезны\
        для таких действий, как внимательное изучение объекта. Вам не захочется\
        повторять описание много раз, поэтому сделать ссылку однократной было бы\
        дружелюбнее для пользователя.</p>\
        <p>Если у вас более, чем одна ссылка относится к одному действию, то все соответсвующие ссылки\
        будут удалены, так что вам не придётся заботиться о игроке, который найдёт способ\
        ещё раз вызвать действие.</p>\
        <p class='transient'>После того, как вы нажмёте на ссылку, мы \
        <a href='qualities'>продолжим.</a></p>",
        {
            actions: {
                "one-time-action": "<p>Как я уже говорил, однократные действия\
                                   в большинстве своём используются для описания\
                                   чего-то в деталях, когда вы не хотите повторять\
                                   один и тот же текст описания в разных местах рассказа.</p>"
            }
        }
    ),
    qualities: new undum.SimpleSituation(
        "<h1>Качества</h1>\
        <p>Хватит о ситуациях, давайте поговорим о персонаже. Персонаж описывается\
        при помощи серии <em>качеств.</em> Это численные значения, которые могут описать\
        всё от врождённых способностей до количества ресурсов,подконтрольных персонажу.\
        Качества показаны в блоке справа от текста.</p>\
        \
        <p>Качества в этом блоке - это те, с которыми вы начали игру. Когда вы\
        <a href='quality-types'>перейдёте к следующей ситуации, </a> не отводите глаз\
        от панели персонажа. Вы заметите, что я подниму ваше качество Ловкости.\
        Этот процесс анимирован и подсвечен, чтобы привлечь ваше внимание.\
        Также вы можете получить повышение Силы, выполнив\
        <a href='./skill-boost'>это действие</a> столько раз, сколько захочется.</p>",
        {
            actions: {
                "skill-boost": function(character, system, action) {
                    system.setQuality("skill", character.qualities.skill+1);
                }
            },
            exit: function(character, system, to) {
                system.setQuality("stamina", character.qualities.stamina+1);
            }
        }
    ),
    "quality-types": new undum.SimpleSituation(
        "<p>Не все качества в панели персонажа отображаются как числа. Внутри они\
        все числовые, но разные качества могут выбирать, как отображать себя. Например,\
        Удача отображается словами (на основе шкалы прилагательных FUDGE RPG)\
        ,а «Новичок» использует лишь галочку.</p>\
        \
        <p>Чтобы увидеть, как изменяется Удача, попробуйте использовать это\
        <a href='./luck-boost'>удачное действие</a> или это\
        <a href='./luck-reduce'>неудачное действие.</a> Заметьте, как Удача\
        использует числовой бонус, когда у неё заканчиваются слова. В Undum\
        существует несколько различных видов отображения, и вы можете легко добавить своё.</p>\
        \
        <p>Когда вы <a href='character-text'>покинете эту ситуацию,</a>\
        я поставлю «Новичок» на ноль. Смотрите на панель персонажа, и вы\
        увидите, что Новичок решает, что ему более не нужно быть видимым, и удаляет себя.\
        Вы также увидите,что,когда последнее качество в группе удаляется(а «Новичок» находится в группе «Прогресс»),\
        тогда заголовок группы также удаляется. Вы можете сообщить Undum, какой группе\
        принадлежит каждое из качеств, и в каком порядке они должны стоять.\
        <p>",
        {
            actions: {
                "luck-boost": function(character, system, action) {
                    system.setQuality("luck", character.qualities.luck+1);
                },
                "luck-reduce": function(character, system, action) {
                    system.setQuality("luck", character.qualities.luck-1);
                }
            },
            exit: function(character, system, to) {
                system.setQuality("novice", 0);
            }
        }
    ),
    "character-text": new undum.SimpleSituation(
        "<h1>Текст персонажа</h1>\
        <p>Над списком качеств находится коротенький кусочек текста, называемый\
        текстом персонажа. Он как-то описывает героя. Он может быть задан\
        любым действием или когда вы входите в или покидаете ситуацию.\
        Это обычное содержимое HTML, как и любой другой текст в Undum.\
        Он также может содержать ссылки Undum, так что это - ещё одно место, куда\
        вы можете поместить действия, которые персонаж может выполнять в течение долгого периода времени.\
        </p>\
        <p class='transient'>Давайте продолжим к \
        <a href='progress'>следующей ситуации.</a> А пока вы это сделаете, я сменю\
        текст персонажа. Заметьте, как он подсвечивается, в точности как и качество,\
        когда изменяется.</p>",
        {
            exit: function(character, system, to) {
                system.setCharacterText(
                    "<p>Мы приближаемся к концу дороги.</p>"
                );
            }
        }
    ),
    progress: new undum.SimpleSituation(
        "<h1>Отображение Прогресса</h1>\
        <p>Иногда вы хотите сделать изменение качества более заметным событием.\
        Вы можете сделать это, анимировав его. Если вы\
        <a href='./boost-stamina-action'>поднимете вашу Ловкость</a>,\
        то вы увидите, что Ловкость изменяется как обычно в панели персонажа.\
        Но вы также увидите появление и анимацию полоски прогресса чуть ниже.</p>",
        {
            actions: {
                // Здесь я иду по неявному пути - ссылка выдаёт действие,
                // которое затем использует doLink, чтобы напрямую изменить
                // ситуацию. Это не рекомендованный путь (я мог бы
                // просто изменить ситуацию по ссылке, но он демонстрирует
                // использование doLink.
                "boost-stamina-action": function(character, system, action) {
                    system.doLink("boost-stamina");
                }
            },
            exit: function(character, system, to) {
                system.animateQuality(
                    'stamina', character.qualities.stamina+1
                );
            }
        }
    ),
    "boost-stamina": new undum.SimpleSituation(
        "<p>Полоса прогресса также удобна в ситуациях, где блок персонажа\
        показывает только общее число качеств, а тем временем какое-нибудь действие меняет\
        одно из них. Например, вы можете захотеть показать прогресс персонажа к следующему уровню - \
        имея уровень персонажа качеством, конечно.</p>\
        \
        <img src='media/games/tutorial/woodcut3.png' class='float_right'>\
        <p>После нескольких секунд, полоса прогресса исчезает, чтобы оставить\
        внимание на тексте. Undum не сделан для игр, где нужно большое управление\
        статистиками. Если вы хотите, чтобы изменение было частью постоянной\
        записи игры, напишите его в тексте.</p>\
        \
        <p>А сейчас мы почти у конца дороги. Но пока что вы шли по этому обучению\
        линейно - от одной ситуации до другой, без единого выбора.\
        Undum сделан, чтобы поддерживать ветвящиеся и сливающиеся рассказы.\
        <span class='transient'>В качестве маленькой иллюстрации\
        этого, выберите сейчас между направлением по <a href='one'>варианту\
        один</a> и по <a href='two'>варианту два.</a></span></p>"
    ),
    one: new undum.SimpleSituation(
        "<h1>Вариант Один</h1>\
        <p>Вы выбрали первый вариант, и возможно, он лучший, так как вариант два\
        написан на плохо зарифмованном коптском.\
        </p>\
        <p>Отсюда остался всего лишь <a href='saving'>маленький шаг</a> до последних\
        кусочков текста в этом обучении.</p>"
    ),
    "two": new undum.SimpleSituation(
        "<h1>Вариант Два</h1>\
        <p>Вы выбрали второй вариант, и он также мой любимый. \
        Я нахожу раздражительными фотографии, сопровождающие первый выбор.\
        Ногти на пальцах не должны гнуться таким образом...</p>\
        <p>Отсюда остался всего лишь <a href='saving'>маленький шаг</a> до последних\
        кусочков текста в этом обучении.</p>"
    ),
    // Опять, мы получаем текст из HTML файла.
    "saving": new undum.Situation({
        enter: function(character, system, from) {
            system.write($("#s_saving").html());
        }
    }),
    "last": new undum.SimpleSituation(
        "<h1>Куда теперь</h1>\
        <p>Итак, это всё. Мы показали весь Undum. Эта ситуация - конечная, поскольку\
        в ней нет дальнейших ссылок. Сообщение «Конец» - это просто HTML вывод ситуации.\
        В нём нет ничего особенного для Undum.</p>\
        \
        <p>Я добавил качество вдохновления в ваш листок персонажа.\
        Настало время для вас вскрыть файл с игрой и написать свою собственную историю.</p>\
        <h1>Конец</h1>",
        {
            enter: function(character, system, from) {
                system.setQuality("inspiration", 1);
                system.setCharacterText(
                    "<p>Вы чувствуете себя вдохновлённым, почему бы не попробовать?</p>"
                );
            }
        }
    )
};

// ---------------------------------------------------------------------------
/* Идентификатор стартовой ситуации. */
undum.game.start = "start";

// ---------------------------------------------------------------------------
/* Здесь мы определяем все качества, присущие нашим персонажам.
 * Мы не должны быть исчерпывающими, но если мы что-то пропустим, то
 * это качество никогда не покажется в панели персонажа. */
undum.game.qualities = {
    skill: new undum.IntegerQuality(
        "Сила", {priority:"0001", group:'stats'}
    ),
    stamina: new undum.NumericQuality(
        "Ловкость", {priority:"0002", group:'stats'}
    ),
    luck: new undum.FudgeAdjectivesQuality( // Fudge as in the FUDGE RPG
        "<span title='Сила, Ловкость и Удача с почтением позаимствованы из книг-игр серии Fighting Fantasy. Слова, описывающие Удачу, взяты из FUDGE RPG. Эта подсказка иллюстрирует то, что вы можете использовать любой HTML в качестве описания качества (в этом случае, тег span, содержащий атрибут названия).'>Удача</span>",
        {priority:"0003", group:'stats'}
    ),

    inspiration: new undum.IntegerQuality(
        "Вдохновение", {priority:"0001", group:'progress'}
    ),
    novice: new undum.OnOffQuality(
        "Новичок", {priority:"0002", group:'progress', onDisplay:"&#10003;"}
    )
};

// ---------------------------------------------------------------------------
/* Качества отображаются по группам в панели персонажа. Эта функция определяет группы,
 * их заголовки (которые могут быть null - нет заголовка), и порядок.
 * Качества без группы появляются в конце. Описание качества,
 * приналежащее к несуществующей группе, является ошибкой.*/
undum.game.qualityGroups = {
    stats: new undum.QualityGroup(null, {priority:"0001"}),
    progress: new undum.QualityGroup('Прогресс', {priority:"0002"})
};

// ---------------------------------------------------------------------------
/* Эта функция запускается перед началом игры. Обычно она используется
 * для того, чтобы настроить персонажа перед игрой. */
undum.game.init = function(character, system) {
    character.qualities.skill = 12;
    character.qualities.stamina = 12;
    character.qualities.luck = 0;
    character.qualities.novice = 1;
    system.setCharacterText("<p>Вы начинаете захватывающее путешествие.</p>");
};
