// ---------------------------------------------------------------------------
// The insides of the Living Will of ER Millhouse
// In this document, you will find the imperatives that drive my Will
// If you are reading it, you have decided that the surface effects of my Will
// are insufficient to satisfy your needs and that you need to know 
// what drives my logic or perhaps wish to encode your Will.
// ---------------------------------------------------------------------------

/* A little tracking to see what the heirs are up to */



  var _gaq = _gaq || [];
  _gaq.push(['_setAccount', 'UA-33603425-1']);
  _gaq.push(['_trackPageview']);

  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();



/* Within this code, you will find how ruling requires a frenzy of naming */
undum.game.id = "markcmarinocom";

undum.game.version = "2.0";

/* Not all comments are written to satisfy external readers */

Array.prototype.shuffle = function() {
var s = [];
while (this.length) s.push(this.splice(Math.random() * this.length, 1)[0]);
while (s.length) this.push(s.pop());
return this;
}

/* Nor have I written all of the comments. */
undum.game.situations = {
    start: new undum.SimpleSituation(
        "<h1>Livingwill Declaration of ER Milhouse</h1>\
        <p style='font-size: 14px; line-height: 1.2em; text-align:justify'>Under the care of the Law Firm of Vholes & Kenge, this document \
        for all purposes, legal and sundry, embodies the Living Will of I, E. R. Millhouse,\
        resident of London and <a href='congo'>the Democratic Republic of Congo</a>.</p>\
        <p style='font-size: 14px; line-height: 1.2em; text-align:justify'>Being of sound mind and \
        <img src='media/games/tutorial/congo.png' class='float_right'>\
        rational thought, but apparently, to all parties save myself,\
        being, at present, so completely incoherent or incapacitated that I am unable to declare my wishes intelligbly,\
        do so specify my intentions here willfully and voluntarily, hereby supplanting,\
        usurping, and obscuring all prior wills and codicils.<br>\
        <a href='identity' class='transient'>(Skip to Identification)</a> \
		<br/><a href='inheritance' class='transient'>(Skip to The Allotments)</a></p> \
		<p><a href='preramble' class='transient'>(Proceed)</a></p>",
		    {
    	   exit:function(character, system, from){
		   system.setQuality("legal", character.qualities.legal+system.rnd.dice(3,6,25)*20);
		   }
		 }
   ),
   
     preramble: new undum.SimpleSituation(
       "<h1>Preramble</h1>\
        <p>On the eve of my death or, to be more precise, the functional equivalence,\
        I lift pen to lips, pen to tongue, pen to parchment...\
       to choose the words that will relinquish my worldly possessions and <a href='theestate'>estate</a>\
        to you, who have picked up this text with anxious grasping fingers.</p>\
        <p class='transient'>Yet like my failing body, my retreating memory, my words \
        <a href='slip'>escape me even as I set them down</a>.</p>"
     ),
  
    slip: new undum.SimpleSituation(
	    "<p>And here you are, anxious, are you not? Perhaps the source of that anxiety is this paper itself, which slips out of your grasp, out of graspability. Perhaps the source is merely your own mortal state. For what is mortality but a persistent, nagging linkage to the possessions that possess us? It is in freeing myself of them, that I shall be free also, I expect, of you.</p>\
        <h1>Clause I</h1>\
        <p>There will be many clauses.</p>\
        <p class='transient'>Let us <a href='taketake'>move on again</a>.</p>"
		),
		
    taketake: new undum.SimpleSituation(
        "<p>As your eyes greedily devour this text, I encourage you to \
        <a href='./grabby' class='once'>grab</a> what you will.\
        In the event that I am incapable of utterance, even via the slightest gesture,\
        the blinking of an eye as in that pretentious film about the butterfly\
        and the bell jar my daughter insisted I watch,\
        then I wish for my estate to be distributed immediately -- \
        before it is completely eroded and dispersed by the amortization\
        of legal and medical expenses accruing in my perpetuity. Moreover, I am enclosing\
        <a href='burial'>burial</a> instructions for that untimely event as well.</p>\
        <p>The boffins at <a href='droxolvox'>Droxol Vox</a> have collaborated with\
        the fellows of legal and financial to create this unique dynamic instrument,\
        this telematic testament, subject to and conductor of the ever-shifting winds of market\
		forces, as a prosethetic to my own will. In a moment of weakness, I inquired whether\
        I could live inside this document, as in a virtual world, and they guffawed,\
        but what is a will but a simulation of ourselves\
        reduced to a set of procedures for the allocation of our resources?</p>\
        <p class='transient'>So into my own perpetual underworld, let my pronoun manifestation\
        be your <a href='identity'>Virgil</a>.</p>",
        {
            actions: {
         'grabby': function(character, system, action) {
                    system.setQuality("wealth", character.qualities.wealth+1);
                     system.setQuality("legal", character.qualities.legal+character.qualities.wealth);
                }
     
            },
        }
    ),
    
    
    burial: new undum.SimpleSituation(
    	"<h1>Burial Grounds</h1>\
    	<p>My remains belong with my adopted homeland.  Place a portion of my ashes in a lead-lined hole\
    	2 feet deep, atop the Crystal Mountains under the base of the <a href='droxolvox'>Droxol Vox</a> Aerial 1 Tower, \
    	the first telecom pylon we erected in thisv virgin, unnetworked land, and sprinkle the rest into a batch of coltan\
    	before it is processed so that I might survive in the airwaves and in the receivers\
    	that deliver news both mundane and life-altering in the network empire I have\
    	slaved so doggedly <a href='identity'>to build.</a></p>"
    ),
    
    
    
    identity: new undum.SimpleSituation(
        "<h1>Clause II: Admit Your Identity</h1>\
        <p>No one can read this document with the voracity of those who have\
        something coming to them, whose fates are wrapped in its letters.\
       <span class='transient'> Which one of my heirs are you?</span>\
        <ul class='options'>  <li><a href='nigel' onClick='_gaq.push([\"_trackEvent\", \"Character\", \"Which\", \"Nigel\"]);'>My son?</a>\
        <li> <a href='salomee' onClick='_gaq.push([\"_trackEvent\", \"Character\", \"Which\", \"Salomee\"]);'>My daughter?</a>\
        <li> <a href='kip' onClick='_gaq.push([\"_trackEvent\", \"Character\", \"Which\", \"Kip\"]);'>My errand boy?</a>\
      		 <li> <a href='gerard' onClick='_gaq.push([\"_trackEvent\", \"Character\", \"Which\", \"Gerard\"]);'>My gardener?</a>\
      			 </ul>",
         {
            
                exit: function(character, system, to) {
                system.write("<p>It is good to know whom I am addressing.</p>");
               system.setQuality("wealth", character.qualities.wealth+system.rnd.dice(2,6,1));
               system.setQuality("drxl", character.qualities.drxl+system.rnd.dice(2,24,0));
               system.setQuality("coltan", character.qualities.coltan+system.rnd.dice(1,6,0));
               system.setQuality("legal", character.qualities.legal+system.rnd.dice(1,6,0));       
                      }
               }
    ),
                    
    
    /* Nigel, have you learned enough about code to read about yourself in this potential form? */
    nigel: new undum.SimpleSituation(
    	"<h1>Nigel</h1>\
    	<p>It is a testament to a certain kind of clemency, that you have returned. You who wished \
    	to have no part in any of my empire, set out on your own to find your fortune, \
    	off to the UK -- not setting foot in the <a href='nigelcongo' class='transient'>Congo</a> -- nothing so very wrongo as being in the Congo --\
    	only to wend your way back, not as the future CEO, heir apparent, but as a mere consultant, working \
    	in accounting.  Was it worth it? Is it a sign of your independence that you do not have a seat \
    	on the Droxol Vox jet, let alone the Board?  Are your hands unsullied by the tantalum because \
    	the theives' guild to which you belong bleeds their ransom as outsourcing?  But I know you have \
    	returned because you love me, becase you were always more like me than I realized.</p>\
		<p>You returned once before, I believe, after I had already lost my sight, and, as a reflection of nothing, I thought you were Kip.  <a href='riverblindness' class='transient'> River blindness</a>.  But of course, you sound nothing like him. It was not an homophonic error. Merely a lapse of recognition, as old men are <a href='inheritance' class='transient'>prone.</a></p>",
    	{
    	    enter: function(character, system, from) {
          	  system.setCharacterText(
                    "<p>My son, Nigel</p>"
                );
                     system.setQuality("pov", 1);  
                }
    	}
    ),
    
    
	/* I am certain that your art projects have lead you to peer into the code of whatever you
	find on the networks, so like your namesake then, your dance always requires a decapitation
	to access the heads of the prophets.*/
    salomee: new undum.SimpleSituation(
    	"<h1>Salomee</h1>\
    	<p>The mere fact you are here is promising and an occasion for me to once again shower you \
    	with my undying love and affection, in as much as I myself am undying at this time. Though you always had a weakness for frail things, always one to salvage the dying before the river could carry them off.  Look at how you took to <a href='kipsalomee'>Kip.</a></p>\
    	<p>Nonperil pride swells these pages as I think on all you have achieved in your\
    	short artistic life, and though you forswore my corporate empire, your spot on the\
    	boards of Droxol Vox and <a href='coxswainsalomee'>Coxswain</a>, you outshined even your brother, Nigel, when you created that <a href='./app'>smartphone\
    	app</a>.  No, neither you nor I knew what you had done.</p>\
    	<p>But you never did know all you were capable of, always covered with that veil of that\
    	word you always clinged to -- dual diagnoses -- a double abdication on the part of the doctors to assign blame or responsibility to their patient for her emotional excesses.\
    	Well, you will not have to worry about that nonsense anymore.  Clearly you are better or \
    	you would not have come back.  Said you never would.  So what could I do but <a href='inheritance'>reward you.</a></p>",
    	{
    	    actions: {
    	    	"app": function(character, system, action){
    	    	 	system.write("<p>What did you call it, locative media -- except you called it LOWcative, as though\
    	it were from those of lower station, rather than LAWcative, as in the Latin case, which\
    	you no-doubt were taught at Sherborne, or at least I paid them plenty to inculcate you with that knowlege.</p>\
    	<p>But that piece!  Filaires, it was called, was it not? And it won the award and the Bienelle in, where was it, Brazil? That they \
    	have Bienelles for cell phone applications in Brazil! To think of it! That piece, raised the\
    	fourth generation phone, the Panderer (produced at great savings in the Beijing Zonix plant), from a utilitarian piece of corporate\
    	productivy-ware to something, how would you say it, some kind of noble artistic venue.\
    	For that alone, I owe you <a href='inheritance'>my most dear treasures.</a></p>");
    	    	}
    	    },
    	    enter: function(character, system, from) {
          	  system.setCharacterText(
                     "<p>My daughter, Salomee</p>"
                );
                     system.setQuality("pov", 2);  
                },
    	}
    ),
    
    
    kip: new undum.SimpleSituation(
    	"<h1>Kip</h1>\
    	<p>When I first met your family, <a href='loss'>your mother</a> wanted to spit in my face.  I could actually see her \
    	welling it up, holding it in the bottom of that mighty jaw, waiting for me to get within distance. \
    	Coxswain had not even acquired the Lubumbashi mine.  I had come to consult with your father, who I had learned \
    	held the respect of the tribe or community, and you were, well, not yet born.  Mind you I had legally purchased the rights to mine \
    	in those parts from the Kabali government, but I had to, as we like to say, win the minds and hearts,\
    	the good will of my prospective miners.  I could tell by the way he wiped his hands before he would \
    	shake mine, that he did not trust me at first.  But my actions in <a href='kiplife'>your case</a> won him over, in a sense.  You are probably anxious to hear your <a href='inheritance' class='transient'>award.</a></p>\
    	", 	
    	{
    	    enter: function(character, system, from) {
          	  system.setCharacterText(
                    "<p>My errand boy, Kip</p>"
                );
                     system.setQuality("pov", 3);  
                }
    	}
    ),
    
    
    gerard: new undum.SimpleSituation(
    	"<h1>Gerard</h1>\
    	<p>The debts we owe our caretakers cannot be paid in simple sums.  You once said your grandfather \
    	walked 50 leagues to repay a man who had lent him a cow during a period of famine.  Alas, I am no \
    	longer able to offer such an ambulatory show of gratitude.  Coxswain, <a href='droxol' class='once'>Droxol Vox</a>, the <a href='congolese'>Congolese Project</a> would be nothing without your intercession, intervention, the constant negotiations you would \
    	undertake with the tribal leaders.  I am in your debt. I am at your service.</p>\
    	<p>My gardener.  <a href='./chance' class='once'> Chance.</a> Gerard.  You were a gardener of the Congolese. And now you and your wife \
    	and son can reap the rewards.  Or possibly you have already reaped and that is why I am here.  Well, \
    	no matter.  You must take every advantage on the <a href='inheritance' class='once'>weeds.</a> </p>",
    	
    	{
    	    actions: {
    	    "chance": function (character, system, action){
    	    system.write("<p>You always asked me to call you Gerard after -- who was it? Gerard Manley Hopkins? \
    	But I always thought of you as Chance, Peter Sellers in that most insightful of comedies.  Brilliant.  I wonder \
    	if I will be seeing him soon.  Remember how in the movie posters, he is walking off into the air? Such\
    	a fate is mine, I suppose, well, walking up, walking down, I suppose it is not up to <a href='inheritance'>me.</a><p>");
    			}
    	     },
    	    enter: function(character, system, from) {
          	  system.setCharacterText(
                    "<p>My gardener, Gerard</p>"
                );
                     system.setQuality("pov", 4);  
                }
    	}
    ),
    
    droxol: new undum.SimpleSituation(
    	"<h1>Droxol Vox</h1>\
    	<p>My legacy, my beloved telecom giant, producer of all things cell phone. Unfortunately, I had\
    	to engage in a Leveraged Recapitalization recently, to ensure against a takeover from an\
    	outside interest.  Afraid that might affect its <a href='inheritance'>worth.</p>",
    	{
    	   exit:function(character, system, from){
    	   var decline = character.qualities.drxl-system.rnd.dice(3,24,0);
    	   if (decline>0){
    	   		system.setQuality("drxl", decline);
    	   		} else {
    	   		system.setQuality("drxl", 1);
    	   		}
    	   	}
    	  }
    	),
    
    
    inheritance: new undum.SimpleSituation(
     	"<h1>Clause III: Distributions</h1>",
     	{

        actions:  {
           'takenigel': function(character, system, action){
            if (character.qualities.pov != 1){
            var grabtotal = 0;
            character.sandbox.sharesall[character.qualities.pov] = character.sandbox.sharesall[character.qualities.pov] + character.sandbox.sharesall[1];
            system.setQuality("wealth", character.qualities.wealth + character.sandbox.sharesall[character.qualities.pov]*character.qualities.drxl);
           	system.setQuality("legal",character.qualities.legal + character.sandbox.sharesall[1]*system.rnd.dice(7,24,0));
           	character.sandbox.sharesall[1] = 0;
           	character.sandbox.stolenfrom[1] = 1;
            system.write("<p>codicil: You now have " + character.sandbox.sharesall[character.qualities.pov] + "% of the shares.</p>");
           }else{
           system.write("<p>You cannot take your own shares.</p>");
           }
          },
 
             'takesalomee': function(character, system, action){
            if (character.qualities.pov != 2){
            var grabtotal = 0;
            character.sandbox.sharesall[character.qualities.pov] = character.sandbox.sharesall[character.qualities.pov] + character.sandbox.sharesall[2];
            system.setQuality("wealth",character.qualities.cash + character.sandbox.sharesall[character.qualities.pov]*character.qualities.drxl);
			system.setQuality("legal",character.qualities.legal + character.sandbox.sharesall[2]*system.rnd.dice(6,24,0));
           	character.sandbox.sharesall[2] = 0;
           	character.sandbox.stolenfrom[2] = 1;
            system.write("<p>codicil: You now have " +character.sandbox.sharesall[character.qualities.pov] + "% of the shares.</p>");
		   /*$(document).ready(function(){
           $("a .oncetransien").click(function(){
           $(this).parents(".oncetransien").hide("slow");		
           }*/
		   }else{
           system.write("<p>You cannot take your own shares.</p>");
           }
          },
             'takekip': function(character, system, action){
            if (character.qualities.pov != 3){
            var grabtotal = 0;
            character.sandbox.sharesall[character.qualities.pov] = character.sandbox.sharesall[character.qualities.pov] + character.sandbox.sharesall[3];
            system.setQuality("wealth",character.qualities.cash+character.sandbox.sharesall[character.qualities.pov]*character.qualities.drxl);
			system.setQuality("legal",character.qualities.legal + character.sandbox.sharesall[3]*system.rnd.dice(1,6,character.qualities.drxl));
           	character.sandbox.sharesall[3] = 0;
           	character.sandbox.stolenfrom[3] = 1;
            system.write("<p>codicil: You now have " +character.sandbox.sharesall[character.qualities.pov] + "% of the shares.</p>");
           }else{
           system.write("<p>You cannot take your own shares.</p>");
           }
          },
             'takegerard': function(character, system, action){
            if (character.qualities.pov != 4){
            var grabtotal = 0;
            character.sandbox.sharesall[character.qualities.pov] = character.sandbox.sharesall[character.qualities.pov] + character.sandbox.sharesall[4];
            system.setQuality("wealth",character.qualities.cash+character.sandbox.sharesall[character.qualities.pov]*character.qualities.drxl);
			system.setQuality("legal",character.qualities.legal + character.sandbox.sharesall[4]*system.rnd.dice(1,6,character.qualities.drxl));
           	character.sandbox.sharesall[4] = 0;
           	character.sandbox.stolenfrom[4] = 1;
            system.write("<p>codicil: You now have " +character.sandbox.sharesall[character.qualities.pov] + "% of the shares.</p>");
           }else{
           system.write("<p>You cannot take your own shares.</p>");
           }
          },
          
        'takecoxswain': function(character,system, action){
        if (character.sandbox.miningrights[character.qualities.pov] != 1) {
		   var newlegal= system.rnd.dice(3,24,0)*75;
           system.setQuality("legal",character.qualities.legal + newlegal);
			if (character.qualities.legal <= character.qualities.wealth) {
			  system.setQuality('wealth', character.qualities.wealth+character.qualities.coltan*1000);
			   system.write('<p>Congratulations! You now have the crowning jewel of my legacy to the Congolese,\
			   who will always know how you have opened this land like a needle in a vein, drawing\
			   bloodflow to an anemic world feinting and faltering!</p>');
			   character.sandbox.miningrights[character.qualities.pov]=1;
			     }else{
				 system.write('<p>Unfortunately, the legal fees far exceeded what you needed to acquire the Coxswain Group.  Of course, you could always try again.</p>');
				 }
			   }else{
			   system.write('<p>You cannot take your own mining group.</p>');
			   }
		   },
 
        'earlykip': function(character, system, action){
        switch(character.qualities.pov){
       			 case 4:
       			 system.write("<p>Do you remember the day, you took your son out behind the house\
       			 and you brought him to the hill overlooking the miners' graveyard?\
       			 You put your hand on his shoulder, leaned down, and spoke directly in his\
       			 ear, gesturing back to the house. I admired the bond of father and son, though I never could stop wondering what it is you said, the privae revelations between others, too fascinating.</p>");
       			 break;
       			 default:
       			 system.write("<p>People find the generous excesses of a dying man odd.</p>");
       			 break;
        	}
        }
        },
        
         enter: function(character, system, from) {
                     system.write("<p>The split:</p>\
					 <p style='font-size: 14px; line-height: 1.2em; text-align:justify'>[Below, you will find your allocations, lest you wish to wrestle with the others to contest my Will.\
					 By pressing on another heir's shares, you may take them for your own,\
					 though you will incur assorted legal fees in the process.]</p>\
					 <p>I hereby bequeath the following without condition to be increased or squandered with uncontrolled discretion:</p>");
					//divvying up Droxol Vox will effect bottom line.
                      var droxol = 100;
                      var allotment = 0;
                      for (i=1; i<4; i++) {
                      allotment = droxol - system.rnd.randomInt(1,droxol);
                      character.sandbox.sharesall[i] = allotment; 
                      droxol = droxol - allotment;
                      }
                      character.sandbox.sharesall[4]=droxol;
                     system.setQuality('wealth', character.qualities.wealth + (character.sandbox.sharesall[character.qualities.pov]*character.qualities.drxl));
                      var themine = system.rnd.randomInt(1,4);
                      
                /* Due to the variability of this process, constructed as requested, this part of the will may not 
				 * hold up to the legal requirements of probate. -- Kisangani
				 */
                      var strings= [
                      "my unfinished international spy thriller, <em>Living Will Kill You</em>, which I was hoping would become\
                      the next installment in the Jack Norrington series, though Salomee always referred to it with a teasing grin as *fan fiction*", 
                      "my diabetic Tabby, King Leo", 
                      "caretakers authority over Aunt Griselda, whom you will most likely still find in the attic of Poundstone Pit, my Nottingham estate",
                      "a bundle of credit default annuities leveraged against the Teacher's Retirement Fund of Sheffield",
                      "a loaded WWII German Glock",
                      "my everlasting regret",
					  "one cow with intermittent udders",
					  "one of the first PDAs in the Congo, they key's white characters worn black by \
					  cigarette-stained fingers",
                      "a bundle of letters from the woman who opened a new vein in my body, which she mined\
                      at her whim with but her glances",
                      "a legacy of shame",
					  "a slightly used Vholes & Kenge legal pad", 
					  "half a dozen decapitated garden gnomes",
                      "a latent but persistant sense of self doubt",
                      "my complete recordings of <em>Downtown Abbey</em>",
                      "the able-bodied servants from the winter cottage and at least one of the others",
                      "21 flavours of guilt",
                      "a morbid taste for colonial literature",
                      "one Congolese Kuba fetish, with its pointed head, long low body, short squat legs -- a kind of mobile phone to the\
                      spirit world",
					  "a castigating, blood-stained missive sent to Mzee Kabila from Che Guevara, which Kabila the younger gave to me over an elegant steak dinner as a gesture toward the capricious turns of fate",
					  "an ivory tusk given me by General Edema, after the only night I bettered him in billiards",
					  "one dog-eared, yellowed English-French dictionary, stained with Malaria vaccines and Moambe sauce",
                      "the sole functioning hearing aid belonging to Margaret, my sole bride, the one she returned to my possession after I telephoned her on that new <em>Droxol Vox 190sF</em> model I had left upon her pillow before departing for the Congo for the final time. In her late 70s by then, and I had popped in to visit her after a terribly long absence, at least ten years.  <em>Thank you for the phone</em>, she wrote to me, <em>I will be sure to listen to you through it with my whole being</em>.  So now you may have it",
					  "one soiled set of rags, partially charred, remnants of a <em>kadogo</em> uniform",
                      "the Lubumbashi football club, <em>Les corbeaux</em>, Tout Puissant Mazembe, now a formidable franchise particularly since the acquisition of those two\
                      prima donnas from Nigeria, \
                      for which I had to trade no less than ten utility players.  Along with the team, you will inherit the ever-lucrative licensing\ rights to the crest with that ball-eating alligator",
					  "my Stanley hat, modified with micro-routers to be a mobile jungle hotspot"
                      ];
                      strings.shuffle ();
					  //sets inheritor
					  character.sandbox.person=1;
                      system.write("<br/><p>To my loving son, Nigel, I leave " + strings.pop() + "<a href='./takenigel' class='oncetransnigel' onClick='_gaq.push([\"_trackEvent\", \"Want\", \"Take\", \"Nigel Shares\"]);'> and " + character.sandbox.sharesall[1] + "% shares of Droxol Vox.</a></p>");
					  //sets inheritor
					  character.sandbox.person=2;
                      system.write("<br/><p class='salomee'>To my loving daughter, Salomee, I leave " + strings.pop() + "<a href='./takesalomee' class='oncetransient' onClick='_gaq.push([\"_trackEvent\", \"Want\", \"Take\", \"Kip Shares\"]);'> and " + character.sandbox.sharesall[2] + "% shares of Droxol Vox</a>. </p>");
					  //sets inheritor
					  character.sandbox.person=3;
                      system.write("<br/><p>To my Dearest Kip, I leave " + strings.pop() + "<a href='./takekip' class='oncetranskip' onClick='_gaq.push([\"_trackEvent\", \"Want\", \"Take\", \"Kip Shares\"]);'> and " + character.sandbox.sharesall[3] + "% shares of Droxol Vox</a>. </p>");
					  //sets inheritor
					  character.sandbox.person=4;
                      system.write("<br/><p>The residuary estate, I bequeath to my gardener<a href='./takegerard' class='oncetransgerard' onClick='_gaq.push([\"_trackEvent\", \"Want\", \"Take\", \"Gerard Shares\"]);'>, including " + character.sandbox.sharesall[4] + "% shares of Droxol Vox</a>. </p>\
                      <p><br/>This is your inheritance lest any emcumbrances presented by my medical bills or legal fees incurred during \
                      the execution of this document. </p>");
                      //Each heir must receive at least a little something to remember me by.
                      var coxswain = system.rnd.randomInt(1,4);
                      system.write("<p>And I almost forgot, to "+ character.qualities.name[coxswain] + " I also leave\
                      the entire control and proprietorship of the <a href='./takecoxswain' class='once'>Coxswain Group.</a><p>");
                      if (coxswain == character.qualities.pov) {
                      	system.setQuality("wealth", character.qualities.wealth+character.qualities.coltan*100);
                      	character.sandbox.miningrights[coxswain]=1;
                      	}
                      switch (character.qualities.pov) 
                
                		{
                		case 1: 
                		system.setQuality("wealth", character.qualities.wealth+1);
                		break;
                		case 2:
                	    system.write("<p>And I leave what you desired most, my sweet <a href='kipstory'>Kip</a>, whom you\
                		wished to interview for your video project, which I believe was going to\
                		mix footage of the Congolese serving class with some type of indigenous poetry. Please treat\
                		him dearly as neither he nor I are particularly tolerant of poetry.</p>");
                		break;
                		default: 
                		system.setQuality("wealth", character.qualities.wealth+3);
                		break;
                		}
						system.write("<br/><p class='transient'><strong>When you are satisfied with the terms of the will, please proceed to the\
					  <a href='endings' class='once'>FINAL CLAUSE.</a></strong></p>");
             },
              exit: function (character, system, to) {
         
              }
         }
    ),
    
endings: new undum.SimpleSituation (
     "<h1>Coddlecils</h1>",
     {
            actions: {
         'tallyup': function(character, system, action) {
   	       var droxvalue = character.qualities.drxl * character.sandbox.sharesall[character.qualities.pov];
		    var expenses = character.qualities.medical + character.qualities.legal;
            character.qualities.net = character.qualities.wealth - expenses; 
			var nostock = character.qualities.wealth-droxvalue;
			var therest = 0;
			if (nostock>0) {
			    therest = nostock
              };		
		 	system.write("<p>-----------------------------------------------------</p>\
			<h3>The Till:</h3>\
		    <p style='font-size: 16px; line-height: 1.4em'>At the close of trading: <br/>\
			Price per Share of Droxol Vox: " + character.qualities.drxl + "<br/>\
			Kilogram of Tantalum: "+ character.qualities.coltan + "<br/>\
			Value of shares of Droxol Vox: &pound;" + droxvalue + "000<br/>\
			Additional Bequests: &pound;"+ therest + "000<br/>\
			Legal Expenses: &pound;"+ character.qualities.legal + "000<br/>\
			Medical Expenses: &pound;"+ character.qualities.medical + "000<br/>\
			Net Benefits of the Will: &pound;"+ character.qualities.net + "000<br/>\
			Unfortunately, I only remain in this chain of procedures.</p>");
		 }
		 },
		 
     enter:  function (character, system, from) {
      	    var droxvalue = character.qualities.drxl * character.sandbox.sharesall[character.qualities.pov];
		    var expenses = character.qualities.medical + character.qualities.legal;
            character.qualities.net = character.qualities.wealth - expenses; 
			var nostock = character.qualities.wealth-droxvalue;
			var therest = 0;
			if (nostock>0) {
			    therest = nostock
              };		
			  var net = character.qualities.net;
              system.write("<p>Very well.  Together, we have chosen our lot.</p>");
              // There cannot be taking without a little giving.
              var payback= [
                   " will take you off the Christmas list.",
                   " will not use emoticons anymore when texting with you.",
                   " will likely never speak to you again.",
				   " will forever let your calls go straight to voicemail.",
				   " will acknowledge you in public, but escoriate you in private.",
                   " has cast a curse upon your soul.",
				   " will leave trying to empathize with you.",
                   " believes you have revealed your true character.",
				   " knew you would not disappoint.",
				   " is preparing a countersuit in an unending cycle of probate actions.",
				   " holds you in less esteem than even me.",
				   " is glad you did not use the occasion of my death to play the martyr.",
				   " suspects Droxol Vox is a Latin incantination of a curse.",
                   " will write you a long letter on the back of a notice regarding this Will with words\
                   that wound you mortally by comparing you to me.",
				   " will accept the words you dish out as poisoned portions.",
				   " will greet you civilly only to sell you swiftly.",
				   " will soon ask you to return all the books you were given as life-changing reads.",
				   " will rise to the occasion by merely looking ascance when your name is mentioned.",
				   " will refer to you as <em>the self-important</em> heir in his memoir.",
				   " would wish you had never been born if it weren't so much fun spreading rumors about you.",
				   " will now remember you as 30 pounds heavier, twice as wrinkled, and half as intelligent."
                      ];
               payback.shuffle();
    	      var i=0;
         	 for (i=1; i<=4; i++) {
    	      if (character.sandbox.stolenfrom[i]==1){
    	            system.write("<p>"+character.qualities.name[i] + payback.pop() + "</p>");
    	      	}
    	      }
    	     if (net>0){
    	      system.write("<p class='transient'>Now you have choices.</p>");
    	      switch (character.qualities.pov) {
    	      case 1:
	    	   system.write("<p>Well, Nigel, what will it be?  You may just have what I need\
	    	   to cure my condition. </p>\
	    	   <ul class='options'><li><a href='save' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Save\", \"Nigel\"]);'>Save me?</a></li>\
    	      <li><a href='dontsave' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Dont Save\", \"Nigel\"]);'>Let me go</a></li></ul>\
    	      ");
    	      break;
    	      case 2:
    	      system.write("<ul class='options'><li><a href='save' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Save\", \"Salomee\"]);'>Save me?</a></li>\
    	      <li><a href='dontsave' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Dont Save\", \"Salomee\"]);'>Let me go</a></li></ul>\
    	      ");
    	      break;
    	      case 3:
    	      system.write("<p>The doctors believe you may be a match for me, you could have\
    	      the necessary matter to cure my condition.</p>\
    	     	    	   <ul class='options'><li><a href='save' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Save\", \"Kip\"]);'>Save me?</a></li>\
    	      <li><a href='dontsave' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Dont Save\", \"Kip\"]);'>Let me go</a></li></ul>\
    	      ");
    	      break;
    	      case 4:
    	      system.write("	    	   <ul class='options'><li><a href='save' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Save\", \"Gerard\"]);'>Save me?</a></li>\
    	      <li><a href='dontsave' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Dont Save\", \"Gerard\"]);'>Let me go</a></li></ul>\
    	      ");
    	      break;
    	      default: 
    	      system.write("<p>nope</p>");
    	      break;
    	      }
    		} else {
    		system.write("<p>It appears my living will must terminate. The cost of my living\
    		is outstripped by the magnanimity of my will. I had anticipated more resourcefulness\
    		on your part, the kind of self-preservation that could have preserved us both.</p>");			
    	 system.write("<p><a href='javascript:location.reload(true)' class='raw' onClick='_gaq.push([\"_trackEvent\", \"Cant Save\", \"Reload\", \"Gerard\"]);'>Read the Will Anew</a></p>");
		 system.write("<p><a href='./tallyup' class='once' onClick='_gaq.push([\"_trackEvent\", \"Ending\", \"Cant Save\", \"Tally\"]);'>See the Final Tally</a></p>");
    		}
   			}
    	}
   ),

tally: new undum.SimpleSituation (
          "<p></p>",
    {    
         enter: function(character, system, from) {
		   	var droxvalue = character.qualities.drxl * character.sandbox.sharesall[character.qualities.pov];
		    var expenses = character.qualities.medical + character.qualities.legal;
            character.qualities.net = character.qualities.wealth - expenses; 
			var nostock = character.qualities.wealth-droxvalue;
			var therest = 0;
			if (nostock>0) {
			    therest = nostock
              };	
		 	system.write("<p>-----------------------------------------------------</p>\
			<h3>The Till:</h3>\
		    <p style='font-size: 16px; line-height: 1.4em'>At the close of trading: <br/>\
			Price per Share of Droxol Vox: " + character.qualities.drxl + "<br/>\
			Kilogram of Tantalum: "+ character.qualities.coltan + "<br/>\
			Value of shares of Droxol Vox: &pound;" + droxvalue + "000<br/>\
			Additional monetary bequests: &pound;"+ therest + "000<br/>\
			Legal Expenses: &pound;"+ character.qualities.legal + "000<br/>\
			Medical Expenses: &pound;"+ character.qualities.medical + "000<br/>\
			Total Expenses: &pound;"+ expenses + "000<br/>\
			Net Benefits of the Will: &pound;"+ character.qualities.net + "000</p>");
		 }
    }
),
   
/* I cannot be certain the following mechanisms will function according to your specifications - Kisangani*/
save: new undum.SimpleSituation (
   "<h1></h1>",
       {
            actions: {
         'tallyupsave': function(character, system, action) {
	   	    var droxvalue = character.qualities.drxl * character.sandbox.sharesall[character.qualities.pov];
		    var expenses = character.qualities.medical + character.qualities.legal;
            character.qualities.net = character.qualities.wealth - expenses; 
			var nostock = character.qualities.wealth-droxvalue;
			var therest = 0;
			if (nostock>0) {
			    therest = nostock
              };		
		 	system.write("<p>-----------------------------------------------------</p>\
			<h3>The Till:</h3>\
		    <p style='font-size: 16px; line-height: 1.4em'>At the close of trading: <br/>\
			Price per Share of Droxol Vox: " + character.qualities.drxl + "<br/>\
			Kilogram of Tantalum: "+ character.qualities.coltan + "<br/>\
			Value of shares of Droxol Vox: &pound;" + droxvalue + "000<br/>\
			Additional Bequests: &pound;"+ therest + "000<br/>\
			Legal Expenses: &pound;"+ character.qualities.legal + "000<br/>\
			Medical Expenses: &pound;"+ character.qualities.medical + "000<br/>\
			Total Expenses: &pound;"+ expenses + "000<br/>\
			Net Benefits of the Will: &pound;"+ character.qualities.net + "000</p>");
			if (character.sandbox.alive){
				system.write("<p style='font-size: 16px; line-height: 1.4em'>And, thanks to you, I am still <em>alive</em>.</p>");
			} else {
			    system.write("<p style='font-size: 16px; line-height: 1.4em'>But, alas, the one I like to call I has perished</p>");
			}
		   }
		 },

     enter:  function (character, system, from) {
           switch (character.qualities.pov) {
    	      case 1:
    	      system.setQuality("wealth", 0);
	    	   system.write("<h1>A Final Disappointmet</h1><p>So, Nigel, as it happens, it appears\
	    	   you cannot cure my condition because, according to my Dutch doctors, flown\
	    	   in at great expense, you are not a match, not as a result of the chance sorting\
	    	   of genes, but, in fact, in any sorting of the genes, leaving me to suppose --\
	    	   for there can be no other presumption -- \
	    	   that you are not my actually my son, scion of my loins. This at least \
	    	   explains how we could have so little in common in terms of our\
	    	   physiognomy.  I would think that such a revelation would be sufficient\
	    	   to invalidate the terms of a will, except the term of this will has outlasted\
	    	   he who willed it.</p>");
			   character.sandbox.alive=0;
			   character.sandbox.sharesall[1]=0;
    	      break;
    	      case 2:
    	      system.write("<h1>At What Cost Life</h1><p>My daughter, my dear daughter, you have saved me, though the\
    	      system reports that in the process you have contracted an infection, which \
    	      has progressed to the point that you will lose the ability to see. I am \
    	      filled with guilt. Though I shall live on, I place your inheritance in a \
    	      payable-on-death account, mine not yours, assuming mine will arrive first.\
    	      Remember always, my edict that no matter what those other doctors say,\
    	      dearest daughter, choose your own adventure.</p>");
    	      break;
    	      case 3:
    	     system.write("<h1>The Life You Save May Be</h1>\
    	     <p>After my eigth month in the DRC, paying a call on that hut your family called home\
    	     amidst unbearable October heat, on that very day I opened the mine,\
    	     I found only your mother, and she looked me up and down, and said,\
    	     <br/>--Beto nki tutasala? \
    	     <br/>--I don't speak Kituba.\
    	     <br/>--Kikongo.\
    	     <br/>--I am sorry. I do not speak either language of your land.\
    	     <br/>--Vous etes comme les Filaires. </p>\
    	     <p/>For the longest time, I thought she was likening me to wires. Seemed unlikely,\
    	     but I was willing to overlook such poetry from one such as your mother, eyes\
    	     glinting like tanatalum, or rather, eyes that would always glare back at me\
    	     from the tanatalum, which is why, of course, I cannot stand to be there\
    	     anymore. Which is why, Kayembe, I do not ever and will not ever look you in the eye.\
    	     </p><p>Take your inheritance early, and use it as a right and proper\
    	     heir.</p>");
    	      break;
    	      case 4:
    	    system.write("<h1>In Perpetuity</h1>\
    	    <p>So, they tell me, I cannot be cured without\
    	    the help of a genetic match.  I have acquired some sort of regional parasite, tainted as it were with Coltan.\
    	    However, your own generosity, means that my body will be kept alive until\
    	    such time as those assets are overtaken by the encumbrances on this inheritance,\
    	    slowly, I will drain those, dying, I suppose, as I have lived.</p>");
    	      break;
    	      default: 
    	      system.write("<p>nope</p>");
    	      break;
    	      }
    	 system.write("<p><a href='javascript:location.reload(true)' class='raw'>Read the Will Anew</a></p>");
		 system.write("<p><a href='./tallyupsave' class='once'>See the Final Tally</a></p>");
    	 }
     }
),

dontsave: new undum.SimpleSituation (
	"<h1>Abandoned</h1>",
    {
            actions: {
         'tallyupdont': function(character, system, action) {
     	    var droxvalue = character.qualities.drxl * character.sandbox.sharesall[character.qualities.pov];
		    var expenses = character.qualities.medical + character.qualities.legal;
            character.qualities.net = character.qualities.wealth - expenses; 
			var nostock = character.qualities.wealth-droxvalue;
			var therest = 0;
			if (nostock>0) {
			    therest = nostock
              };				
		 	system.write("<p>-----------------------------------------------------</p>\
			<h3>The Till:</h3>\
		    <p style='font-size: 16px; line-height: 1.4em'>At the close of trading: <br/>\
			Price per Share of Droxol Vox: " + character.qualities.drxl + "<br/>\
			Kilogram of Tantalum: "+ character.qualities.coltan + "<br/>\
			Value of shares of Droxol Vox: &pound;" + droxvalue + "000<br/>\
			Additional Bequests: &pound;"+ therest + "000<br/>\
			Legal Expenses: &pound;"+ character.qualities.legal + "000<br/>\
			Medical Expenses: &pound;"+ character.qualities.medical + "000<br/>\
			Net Benefits of the Will: &pound;"+ character.qualities.net + "000<br/>\
			And I am survived only by my Will.</p>");
			
		 }
		 },
    enter:  function (character, system, from) {
     switch (character.qualities.pov){
          case 1: system.write("<p>So this, then, would be my inheritance, I suppose.\
          Let it be understood that I expected nothing less.</p>");
          break;
          case 2:system.write("<p>Well, perhaps this is just repayment, though hopefully\
          not for any sense of lack of love.  When the doctors first called me, reporting\
          of your dual diagnsis, it was during a scouting mission here.  It was during\
          a period of armed conflict and the satellite call actually came through the \
          US embassy.</p>\
          <p>Dual diagnosis they said, which as I came to understand in medical\
          parlance stood for a double abdication from assigning blame for behavior\
          or attributiing the excesses of emotion and substance use to what has historically\
          been called the artist's temperament.  How could I not feel for you from across\
          the ocean, feel the indignity of this complete and utter failure to acknowledge\
          what you truly were.  I gave you what you would need for the life of the artist\
          even if I did not always understand your art, and you ran that ship aground\
          each time, in more ragged and savage reefs of addiction and mania. I should not\
          therefore be surprised at your choice, though I presume there is not much I to\
          perceive your triumphant retribution on me.   My love is yours as it was in\
          life. </p>");
          break;
          case 3:system.write("<p>Honestly, I should have expected little else from\
          an errand boy, though I would have expected a tad more clemency for the\
          gifts I bestowed upon your family and for rescuing you from that band of brigands.</p>");
          break;
          case 4:system.write("<p>A paticular scene repeats in my mind's eye:</p>\
          <p>A mere few days ago, or was it yesterday, or several weeks with respect to my establishing this instrument.  Your son is staring out the window.  You are leaning down to lift that grand silver tray, bringing something for me, a bowl of noodles in a brackish sauce. Happiness, relief, a look I have not seen in your eyes since before her funeral.  Something about wires, you whisper, <em>filaire</em>.<p>\
		  <p>Your son does not acknowledge you when you say this, but as you exit, he lets the phone slide out of his hand onto the ground where the screen shatters.</p>\
		  <p>Something in your tone is unmistakable, a tone of grim prescience like your tone the night of the incident with the miners, like the morning we disovered Kip had been taken.  Your choices have stymied the clauses, my will has become fragmented.</p>");
          break;
          default:system.write("<p>So this, then, would be my inheritance, I suppose.</p>");
          break;
     
     
     	}
     	    	 system.write("<p><a href='javascript:location.reload(true)' class='raw'>Read the Will Anew</a></p>");
				 system.write("<p><a href='./tallyupdont' class='once'>See the Final Tally</a></p>");
     }
    }

),


nigelcongo: new undum.SimpleSituation(
	"<p>The last time you set foot in the Congo, we were walking though the village.  I thought seeing some of your future subjects would make you want to remain and reign over them.  We passed the witch doctor as I liked to call him, though I trusted him with my life, and though he was educated in Bristol, saw him drawing what looked like pasta from the arm of that man, long stringy strands, maybe rice noodles would be more accurate. <em>Filariasis</em>, he said as we passed.\
	<br>--That is how you build an empire these days.\
	<br>--Through parasites? you asked. \
    <br>--Through insinuation in the very veins of culture, I replied.\
    <br>--Sounds like a filthy business model, you said, spitting into the dirt.\
	<br>And as we watched the doctor pull the last strand out, a necklace, a shoelace, stretchy taffy strand, I smiled, and whispered, oh, the dream of complete <a href='inheritance'>incorporation.</a></p>"
	),
	
	riverblindness: new undum.SimpleSituation(
	"<p>Onchocerciasis.  That's what they call it.  River blindness.  Contracted by round worm or some other parasite.  Took away my ability to see, so I must rely on my sense of touch to see if you are hairy or smooth, and I would not be surprised if, like those clever cads from the Bible, you deceived me as well.  And what would you learn if you pretended to be Kip.  What do you think you might discover, and would it make any sense without having suffered his misery as <a href='inheritance'>well?</a></p>"
	),
	
    congo: new undum.SimpleSituation(
	"<h1>Democratic Republic of Congo</h1><p>From an early age at Sherborne, I would read about the Congo, the vast jungle through which one would steam on a river boat, natives hurling spears past the skin of your pith helmet. The Congo, I was taught, is to serve as the geographic unconscious of the imperial subject.  Thus, from the moment I step off the plane, walk to retrieve my baggage, it is not as though I am directed by my conscious mind, but instead following some subterranean rhythms of my darkest soul flowing relentlessly to the Nzere, the river that swallows rivers.  Surely, that accounts for my behavior here, why I behave like a man in a dream who has entered another man's home, sits in his chair, lifts the other man's scotch glass to his lips as if he himself had just set it <a href='preramble'>down.</a></p>",  
{	              
				  enter: function(character, system, from) {
               system.setCharacterText("<p>Your interest shall earn you interest.</p>");
               
				}	
}
	),
	
	droxolvox: new undum.SimpleSituation(
	"<h1>Droxol Vox</h1><p>Never another like her in the world, a corporation of vast holdings whose fibres stretch round the globe.  Every communicative act passes through her networks, from the briefest phone call to the most urgent database request.  The MRI reports you have cancer. Droxol Vox. Mother sends a text that you are illegitimate. Droxol Vox.  Thanks in no small part to a boundless supply of <a href='tantalite'>Tantalite</a>.  And perhaps thanks in no smaller part to my own industry, avarice, and <a href='identity' class='transient'>ambition.</a></p>"
	),
	
	coxswainsalomee: new undum.SimpleSituation(
    "<p>Never wanted any part of The Coxswain Group, no, but what do you think was funding all your little projects? Do you think they would function with out Tantalite? But you were fixated on the <a href='coxswainincident' class='transient'>allegations</a> from villagers.  Fixated on Kip, as if he could somehow save the world.  We did what we could for him.  And I did all I could for you.  And if that at times took the form of benign neglect, perhaps I was merely looking out for your best interests, as I'd hope you'd do for me now in my hour of dire <a href='inheritance' class='transient'>need.</a></p>"
	),
	
	coxswainincident: new undum.SimpleSituation(
	"<p>Oh, you believed every word the villagers told you.  About the executions.  That they used the Coxswain trucks to transport them to their place of execution.  How could I stop them from hijacking the trucks. I assure you, they were not working for the mine when they carried out these actions.  The mass grave never turned up anything <a href='inheritance'>definitive</a>.</p>",
	{	              
				  exit: function(character, system, from) {
	system.setQuality("drxl", character.qualities.drxl-system.rnd.dice(2,6,1)*10);
	}
}
	),
	
	kipsalomee: new undum.SimpleSituation(
	"<p>You always treated that poor little chap so kindly, more like a brother than Nigel, felt sorry for him, felt pity for him.  As you should, no doubt, as we all should on the unfortunate son of the Congo.  Not that we didn't give him a better life.  After what he had <a href='kipsaved'>suffered</a>, not sure he ever recovered.  Not that we were responsible.  But you took the white woman's burden on your shoulders did you not.  And for that I feel you deserve something more than my <a href='inheritance' class='transient'>respect.</a></p>"
	),
	
	kipsaved: new undum.SimpleSituation(
	"<p>I rescued him from those guerillas as soon as I humanly could.  You know this.  I could not sleep, could not eat, when they took him, you have my word on that.  I spared no cost in graft, turned down no extorter, paid every ransom to get him back.  We had planted a garden in a snake pit. And when he came back, you saw my tears.  But that is all out of my hands now.  My ability to make change is relegated to a few final <a href='inheritance'>commands.</a></p>"
	),
	
	kiplife: new undum.SimpleSituation(
	"<p>I did you no special favours. After I purchased your freedom from those brigands, my charity was done.  The rest of your fortunes you determined, deriving your own expectancies.  You became like a member of the family through the sheer magnanimity of your own spirit.  I was grateful that you offered some companionship to my daughter.  I was truly saddened by the loss of your mother.  But let me not give any of this too much <a href='inheritance'>pause.</a></p>"
	),
	
    tantalite: new undum.SimpleSituation(
    "<h1>Tantalite</h1>\
    <p>Ta, Tantalite, aka coltan, aka columbite-tantalite, progenitor of tantalum and niobium\
    was an unexpected global star in commodities markets, thanks to its capacity for capacitors.\
    No doubt the machine you are viewing my Will on capitalizes on this capital element.  \
    The Coxswain Group, of which I am the only remaining trustee, in as much as I remain,\
    acquired several highly profitable profusely productive <a href='mine'>mines</a> in the Democratic Republic\
    of Congo in 1998.  As it turns out, Tantalite provides the red blood cells of the circulatory communication <a href='identity' class='transient'>system.</a></p>"
    ),
  
    mine : new undum.SimpleSituation(
   "<h1>Lubumbashi Mine</h1>\
   <p>Some fifteen years back, I had the opportunity to visit the mine.  That fellow called Kayembe\
    then a miner, finding a prosperous income for his family with only minimal literacy\
    and no training.  I gave him an even more prosperous position.\
	Imagine the opportunity for him and his family.  At the time, he had only\
    a wife, young, long, and obsidian as they like them in those parts.  Ambitious. But later he,\
    his wife, and his scion, also Kayembe, would earn, what is considered in the Congo, a respectable\
    lower middle class lifestyle, at least until the mother was brutally raped and slaughtered by a \
	militia.  Epic tragedy.  Pains me to describe, so let us <a href='identity'>move on</a>.<p>" 
     ),
	 
	 theestate: new undum.SimpleSituation(
	 "<h1>The Estate</h1><p>My house was an absolute jungle, a purgatory of plants, before Gerard tamed it, created my fortress of fauna.  t was designed to look natural as the rainforest and to be just as impenetrable, protected by an experimental invisible fence created by radio waves surrounded by a more traditional iron-rod one.  I remember the first time the neighbours, who lived 13 miles down the mostly dirt road, noticed my fence and gaped at the sight: a phalanx of iron rods, every fourth one topped with a severed head of a garden gnome.</p>\
	 <p>I hereby bequeath that property of the main residence and surrounding gardens to the good people of the Congo to be transformed by the Coxswain Educational Fund into a museum of natural history, the history from which all other Congolese histories have been so violently born. The E R Millhouse Museum of the Nature of the Congo is to be built on the model of the exploratorium rather than the stuffed animal, plastic natives variety, packed with every variety of interactive exhibit, run on Droxol Vox-built technologies, designed by my daughter Salomee.</p>\
	 <p class='transient'>But such specifications must feel like a digression, as you are awaiting my full declarations, <a href='slip'>I presume</a>.</p>",
	 {	              
				  exit: function(character, system, to) {
               system.write("<p>The furnishings and the heads are yours.</p>");
               system.setQuality("wealth", character.qualities.wealth+system.rnd.dice(3,24,100));
				}	
}
	 ),
	 
	 
	 
	 congolese : new undum.SimpleSituation(
	 "<h1>General Edema</h1>\
	 <p>You mediated my encounters with the Congolese, introducing me to <a href='generale'>General Edema</a>, arranging our little palaver, such an expedient.  A prime chap, the kind with whom you could gladly enjoy stag films and bitters, though he preferred that palm wine, <em>kallu</em>.  What could I ever do to repay you for introducing the man that would ensure that my mining was always supplied with a steady stream of workers and that the paperwork would all be negotiated?  Of course, the general could not be expected to leave off his own <a href='inheritance'>preoccupations.</a></p>"  
	 ),
	 
	 generale: new undum.SimpleSituation(
	 "<p>It was just that one incident in 2004. They said they needed trucks.  He borrowed them, Coxswain trucks.  Commandeered them.  It was a time of war -- or the constant verge of civil unrest.  So he transported the villagers there -- they allege, as this was never proven -- to that remote village.  And the bodies that were found, unrecognizable.  That was what sealed it for me.  Stories, slander is always attended by <a href='tantalitepoisoning'>unverifiable evidence</a>. In any case, what they did with the trucks was out of my hands, and Coxswain was never held responsible.  How could it be? What the miners chose was their own doing and casts no more stain upon Coxswain than it does upon you for helping them find the work in the first <a href='inheritance'>place.</a></p>",
         {
            
                exit: function(character, system, to) {
                system.write("<p>Such rumours are bound, I suppose, to affect investor confidence.</p>");
               system.setQuality("drxl", character.qualities.drxl-system.rnd.dice(2,24,0));
               system.setQuality("coltan", character.qualities.coltan-system.rnd.dice(1,6,0));       
                      }
               }
    ),
	 
	tantalitepoisoning: new undum.SimpleSituation( 
	"<p>We conversed in my study, thick with mosquitos though it was. \
	<br>--Have you ever seen the effects that coltan has on a man? asked the General.\
	<br>--Seems to mostly incite greed, I replied, avarice, uncontrollable want, opportunity.\
	<br>--Death of a most bleak kind, the general replied setting down his tea cup.\
	<br>--Lots of things lead to that, General.' I replied. 'Guns, jealous lovers, children, disease.  What's so ghastly about it?\
    <br>--The general rose and walked to the spotless French window. It doesn't always kill you.<\p>\
    <p>What a morbid cur he could be.  But enough of him.  What about <a href='inheritance'>you?</p>"
	 ),
	 
	 mother: new undum.SimpleSituation(
	 "<p>She had trade winds of her own, coursing the streamlets of sweat from her neck, down the furious mountains\
	 and then cycling back to rustle her morning gown.  Her favorite activity was to recline on that day bed or the fourpost, beneath the\ misquito netting, tracing her finger on the trackball of the PDA, skimming the headlines, though when roused and about, she was rarely\ at rest.  <a href='kipborn'>Before you were born</a>, she had done the same with the newspaper, combing it, \
	 <a href='inheritance'>devouring it.</a></p>"
     ),
	 
	loss: new undum.SimpleSituation(
    	  "<p>When I first met her, she was robed in a florid brown wrap, printed with lurid Congo\ Cockatoos, I'd later\ discover was purchased at Macy's along with that blue track suit she preferred to\ wear.  Educated in international\ schools, MBA from Cornell, I never understood <a href='mother'>why she\ returned to the Congo.</a>\
		  I couldn't believe it was for your father, though I've been wrong <a href='inheritance'>before</a>.</p>"
    	),
    	
	 
	 kipborn: new undum.SimpleSituation(
	 "<p>When you were born, the family dynamic changed. Your father came to work for me.  Your mother \
    	became, what is it your people say, she had turned <em>yela</em>. <em>Muntu nteka</em>, your father would mutter\
    	under his breath from time to time. -- Nigel is no corporate King, was her mantra, as if I didn't already know as much.\
		But you \
    	and I struck off a keen friendship from the start, and you have since been more loyal than any \
    	Congolese, and I daresay, you know how to run my business, better than any child of <a href='inheritance'>mine</a>.</p>",
         {
                exit: function(character, system, to) {
               system.setQuality("wealth", character.qualities.wealth+system.rnd.dice(2,24,10));      
                      }
               }
    ),
	 
	 kipstory: new undum.SimpleSituation(
	 "<p>It was in her care from which he was taken.  His own mother on her way to the post or some business meeting at\
	 the bank, when they took him.  They did not know who he was, who she was.  Hade him for three years, and\
	 in that time, he was made to suffer such attrocities as neither you nor your brother could ever imagine\
	 though you profited from both.  And that, in the end, is the difference between him and you.  You chose to\
	 be ignorant of that which you took no part in yet prospered you so while he was forced to confront a horror\
	 from which he could take only the mutilation of his innocense. But you are probably wondering <a href='endings'>what remains for you.</a></p>"
	 ),
	 
    "saving": new undum.Situation({
        enter: function(character, system, from) {
            system.write($("#s_saving").html());
        }
    }),
};

// ---------------------------------------------------------------------------
/* This is not the actual start of the document*/
undum.game.start = "start";

// ---------------------------------------------------------------------------
/* What I am titling qualities here, may not be qualities at all, but aspects of the modeled world,
 * tied to the document but not the world, which i assume is what you wanted -- Kisangani */
// This is all what I wanted but obviously wished for none of it. */
undum.game.qualities = {

    wealth: new undum.IntegerQuality(
        "Bequests", {priority:"0001", group:'stats'}
    ),
    legal: new undum.NumericQuality(
        "Legal Fees", {priority:"0002", group:'stats'}
    ),
    medical: new undum.NumericQuality( 
        "<span title='Reminder of how to use tool tips'>Med. Fees</span>",
        {priority:"0003", group:'stats'}
    ),
    coltan: new undum.IntegerQuality(
         "Ta", {priority:"0005", group: 'stats'}
    ),
    drxl:   new undum.IntegerQuality(
          "DRXL",  {priority:"0006", group: 'stats'}
    ),
    pov: new undum.WordScaleQuality(
        "POV",  [
            "Unnamed".l(), "Nigel".l(), "Salomee".l(), "Kip".l(),
            "Gerard".l()
        ], {priority:"0007", group:'stats'}
   ),
    inspiration: new undum.NonZeroIntegerQuality(
        "Inspiration", {priority:"0001", group:'progress'}
    )
};

// ---------------------------------------------------------------------------
/* I have given priority as you assigned it in the alpha document, this can be changed
 *  at any times prior to the execution of the will - Kisangani */
undum.game.qualityGroups = {
    stats: new undum.QualityGroup(null, {priority:"0001"}),
    progress: new undum.QualityGroup('Progress', {priority:"0002"})
};

// ---------------------------------------------------------------------------
/* These are the variables you requested.  They are attached to qualities but may not be */
undum.game.init = function(character, system) {
    character.qualities.cash = 0;
	character.sandbox.alive = 1;
	character.qualities.net = 0;
    character.qualities.wealth = 0;
    character.qualities.legal = 0;
    character.qualities.medical = 0;
    character.qualities.stuff = 0;
    character.qualities.novice = 1;
    character.qualities.inspiration = 0;
    character.qualities.pov = 1;
    character.qualities.name = new Array ();
    	character.qualities.name[0] = "None";
    	character.qualities.name[1] = "Nigel";
    	character.qualities.name[2] = "Salomee";
    	character.qualities.name[3] = "Kip";
    	character.qualities.name[4] = "Gerard";
    character.qualities.coltan = 2;
    character.qualities.drxl = 65;
    character.sandbox.mine = 100;
     character.sandbox.shares = 0;
     character.sandbox.shareskip = 0;
	 character.sandbox.person = 1;
     character.sandbox.sharesall = new Array ();
     	character.sandbox.sharesall[1]=1;
     	character.sandbox.sharesall[2]=1;
     	character.sandbox.sharesall[3]=1;
     	character.sandbox.sharesall[4]=1;
     character.sandbox.stolenfrom = new Array ();
     character.sandbox.miningrights = new Array ();
     	character.sandbox.miningrights[1]=0;
     	character.sandbox.miningrights[2]=0;
     	character.sandbox.miningrights[3]=0;
     	character.sandbox.miningrights[4]=0;
    system.setCharacterText("<center><p>It is never too early to tally <br/>your inheritance.</p></center>");
   
};
//----------------------------------------------------------
undum.game.name = function( ) {
	character.qualities.pov + 'Hello';
	};
		
undum.game.turn = function (character, system) {
     character.qualities.cash++;
 };
