/*
 * Decompiled with CFR 0.152.
 */
import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class AdvRoomStub {
    private static final String MARKER = "-----";
    private int roomNumber;
    private String roomName;
    private boolean visited;
    private boolean initialized;
    private ArrayList description;
    private ArrayList motionTable;
    private ArrayList objects;

    public int getRoomNumber() {
        this.checkInitialized("getRoomNumber");
        return this.roomNumber;
    }

    public String getName() {
        this.checkInitialized("getName");
        return this.roomName;
    }

    public String[] getDescription() {
        this.checkInitialized("getDescription");
        String[] lines = new String[this.description.size()];
        int i = 0;
        while (i < this.description.size()) {
            lines[i] = (String)this.description.get(i);
            ++i;
        }
        return lines;
    }

    public void addObject(AdvObject obj) {
        this.objects.add(obj);
    }

    public void removeObject(AdvObject obj) {
        this.objects.remove(obj);
    }

    public boolean containsObject(AdvObject obj) {
        return this.objects.contains(obj);
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public AdvObject getObject(int index) {
        return (AdvObject)this.objects.get(index);
    }

    public void setVisited(boolean flag) {
        this.checkInitialized("setVisited");
        this.visited = false;
        this.visited = flag;
    }

    public boolean hasBeenVisited() {
        this.checkInitialized("hasBeenVisited");
        return this.visited;
    }

    public AdvMotionTableEntry[] getMotionTable() {
        this.checkInitialized("getMotionTable");
        int nEntries = this.motionTable.size();
        AdvMotionTableEntry[] array = new AdvMotionTableEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            array[i] = (AdvMotionTableEntry)this.motionTable.get(i);
            ++i;
        }
        return array;
    }

    public boolean readFromFile(BufferedReader rd) {
        try {
            this.objects = new ArrayList();
            String line = rd.readLine();
            while (line != null && line.length() == 0) {
                line = rd.readLine();
            }
            if (line == null) {
                return false;
            }
            this.roomNumber = Integer.parseInt(line);
            this.roomName = rd.readLine();
            this.description = new ArrayList();
            while (!(line = rd.readLine()).equals(MARKER)) {
                this.description.add(line);
            }
            this.motionTable = new ArrayList();
            while ((line = rd.readLine()) != null && line.length() != 0) {
                this.motionTable.add(this.parseMotionEntry(line));
            }
            this.initialized = true;
            return true;
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private AdvMotionTableEntry parseMotionEntry(String line) {
        int space = line.indexOf(" ");
        String direction = line.substring(0, space).trim().toUpperCase();
        String movement = line.substring(space + 1).trim();
        int destinationRoom = 0;
        String key = null;
        int slash = movement.indexOf("/");
        if (slash == -1) {
            destinationRoom = Integer.parseInt(movement);
        } else {
            destinationRoom = Integer.parseInt(movement.substring(0, slash).trim());
            key = movement.substring(slash + 1).trim().toUpperCase();
        }
        return new AdvMotionTableEntry(direction, destinationRoom, key);
    }

    private void checkInitialized(String caller) {
        if (!this.initialized) {
            throw new ErrorException(String.valueOf(caller) + ": Room is not initialized");
        }
    }
}

