UNIT GRAMATIC;

INTERFACE

TYPE
    Caracteres = SET OF CHAR;
    T_Articulos = ARRAY [1..18] OF STRING;
    T_Salidas = ARRAY [1..8] OF STRING;

FUNCTION Es_Separador(caracter :CHAR) :BOOLEAN;
FUNCTION Es_Articulo(frase :POINTER) :BOOLEAN;
FUNCTION Es_Salida(frase :POINTER) :BOOLEAN;

IMPLEMENTATION
USES crt, ES;

PROCEDURE Conjunto_Articulos(VAR arti :T_Articulos);
BEGIN
     arti[1] := 'AND';
     arti[2] := 'THEN';
     arti[3] := 'THE';
     arti[4] := 'MY';
     arti[5] := 'YOUR';
     arti[6] := 'HIS';
     arti[7] := 'HER';
     arti[8] := 'ITS';
     arti[9] := 'ANY';
     arti[10] := 'SOME';
     arti[11] := 'ABOUT';
     arti[12] := 'THIS';
     arti[13] := 'THAT';
     arti[14] := 'THEIR';
     arti[15] := 'A';
     arti[16] := 'AN';
     arti[17] := 'AT';
     arti[18] := 'INTO';
END;

PROCEDURE Conjunto_Salidas(VAR salida :T_Salidas);
BEGIN
     salida[1] := 'N';
     salida[2] := 'S';
     salida[3] := 'E';
     salida[4] := 'W';
     salida[5] := 'UP';
     salida[6] := 'DOWN';
     salida[7] := 'ENTER';
     salida[8] := 'LEAVE';
END;

FUNCTION Es_Separador(caracter :CHAR) :BOOLEAN;
VAR
   separadores :Caracteres;
BEGIN
     separadores := [' ', ',', ';', '.'];
     Es_Separador := (caracter IN separadores);
END; { Es_Separador }

FUNCTION Es_Articulo(frase :POINTER) :BOOLEAN;
VAR
   cont :WORD;
   arti :T_Articulos;
BEGIN
     Conjunto_Articulos(arti);
     cont := 1;
     WHILE ((cont <= 14) AND
           (NOT(Iguales_catx(frase, arti[cont])))) DO
               cont := cont + 1;
     Es_Articulo := (cont <= 14);
END; { Es_Articulo }

FUNCTION Es_Salida(frase :POINTER) :BOOLEAN;
VAR
   cont :WORD;
   salidas :T_Salidas;
BEGIN
     Conjunto_Salidas(salidas);
     cont := 1;
     WHILE ((cont <= 8) AND
           (NOT(Iguales_catx(frase, salidas[cont])))) DO
               cont := cont + 1;
     Es_Salida := (cont <= 8);
END; { Es_Salida }

END. { GRAMATIC }
