-- retrolib.i: a minimal library for Alan 3 games.
-- 2016-05-19 (2nd revision) by Felix Pleșoianu <http://felix.plesoianu.ro/>
-- If you are asking what license this software is released under,
-- you are asking the wrong question. 

-- Essential meta verbs

verb 'save' does save. "Game saved." end verb.
verb 'restore' does restore. "Game restored." end verb.
verb 'restart' does quit. end verb.
verb 'quit' does quit. end verb.
syntax 'save' = 'save'.
	'restore' = 'restore'.
	'restart' = 'restart'.
	'quit' = 'quit'.
	'quit' = 'q'.

verb transcript_on does
	transcript on.
	"Starting transcript." -- Yes, include notification in transcript.
end verb.
verb transcript_off does
	transcript off.
	"Stopping transcript."
end verb.
syntax transcript_on = 'transcript' 'on'.
	transcript_on = 'script' 'on'.
	transcript_off = 'transcript' 'off'.
	transcript_off = 'script' 'off'.

verb verbose does
	visits 0.
	"Verbose mode enabled."
end verb.
verb brief does
	visits 1.
	"Brief mode enabled."
end verb.
verb superbrief does
	visits 9.
	"Superbrief mode enabled."
end verb.
syntax 'verbose' = 'verbose'.
	'brief' = 'brief'.
	'superbrief' = 'superbrief'.


-- Limbo and the compass directions

the limbo isa location
	exit north, n, south, s, east, e, west, w to limbo.
	exit northeast, ne, southeast, se to limbo.
	exit southwest, sw, northwest, nw to limbo.
	exit up, u, down, d, 'in', out to limbo.
end the limbo.
-- Taking a hint from Python, add a null object that can be tested against.
the none isa object at limbo end the none.


-- Other basics

verb 'wait' does "Time passes..." end verb.
syntax 'wait' = 'wait'. 'wait' = 'z'.


verb 'look' does look. end verb.
syntax 'look' = 'look'.
synonyms l = 'look'. -- Make 'l' a synonym so it works on search, examine, etc.

add to every thing
	verb examine does
		"You see nothing special about " say the this. ".$n"
	end verb.
end add to.
syntax examine = 'examine' (obj)
	where obj isa thing
	else "It doesn't make sense to examine that."
syntax examine = 'x' (obj).
	examine = 'look' (obj).
	examine = 'look' 'at' (obj).

every darkroom isa location
	is dark.
	description
		check this is not dark
		else "It's too dark to see much."
	verb examine
		check this is not dark
		else "It's too dark to get a good look."
	end verb.
end every.


add to every object
	verb 'use' does "How, exactly?" end verb.
	verb use_on when obj does "How, exactly?" end verb.
	verb search does "You find nothing of interest." end verb.
end add to.
syntax 'use' = 'use' (obj).
	use_on = 'use' (obj) 'on' (obj2)
		where obj2 isa object
		else "That doesn't even make sense."
	use_on = 'use' (obj) 'with' (obj2).
syntax search = 'search' (obj).
	search = 'look' 'in' (obj).
	search = 'look' 'inside' (obj).
	search = 'look' 'through' (obj).


-- The inventory

the player_inventory isa object
	name inventory
	description
	with container
		taking thing. -- So you can even *attempt* to pick up actors.
		header "You are carrying:"
		else "You are empty-handed."
	verb examine does only list this. end verb.
	verb take does only list this. end verb.
end the player_inventory.

add to every location
	entered
		if current actor = hero then
			locate player_inventory here.
		end if.
end add to.

verb 'inventory' does list player_inventory. end verb.
syntax 'inventory' = 'inventory'.
	'inventory' = 'i'.

syntax take = 'take' (obj)*
	where obj isa thing
	else "It doesn't make sense to pick that up."
syntax take = 'get' (obj)*.
	take = 'pick' 'up' (obj).
	drop = 'drop' (obj)*.

-- Remember to make objects portable if you want to override "take" on them.	
add to every thing
	is not portable.
	verb take
		check obj not in player_inventory
			else "You already have " say the obj. "."
		and obj is portable
			else "That's not something you can pick up and carry."
		does
			locate obj in player_inventory.
			"Taken."
	end verb.
	verb drop
		check obj in player_inventory
			else "But you don't have it."
		does
			locate obj here.
			"Dropped."
	end verb.
end add to.


-- NPC interaction

syntax talk_to = 'talk' 'to' (act)
	where act isa actor
		else say the act. "is busy being inanimate."
syntax show_to = 'show' (obj) 'to' (act)
	where obj isa thing
		else "You can't exactly point at " say the obj. "."
	and act isa actor
		else say the act. "is busy being inanimate."
syntax give_to = 'give' (obj) 'to' (act)
	where obj isa thing
		else "You can't exactly get ahold of " say the obj. "."
	and act isa actor
		else say the act. "is busy being inanimate."
syntax tell_about = 'tell' (act) 'about' (obj)!
	where obj isa thing
		else say the obj. "is a rather abstract topic."
	and act isa actor
		else say the act. "is busy being inanimate."
syntax ask_about = 'ask' (act) 'about' (obj)!
	where obj isa thing
		else say the obj. "is a rather abstract topic."
	and act isa actor
		else say the act. "is busy being inanimate."
syntax ask_for = 'ask' (act) 'for' (obj)!
	where obj isa thing
		else say the obj. "is a rather abstract topic."
	and act isa actor
		else say the act. "is busy being inanimate."

add to every actor
	verb talk_to does
		say the this. "has little to say."
	end verb.
	verb show_to when act does
		say the this. "doesn't seem interested."
	end verb.
	verb give_to when act does
		say the this. "doesn't seem interested."
	end verb.
	verb tell_about when act does
		say the this. "doesn't show much of a reaction."
	end verb.
	verb ask_about when act does
		say the this. "has little to say about " say the obj. "."
	end verb.
	verb ask_for when act does
		say the this. "can't seem to help you."
	end verb.
end add to.


-- Doors and locks

syntax open = open (obj).
	close = close (obj).
	lock = lock (obj).
	lock_with = lock (obj) 'with' (obj2).
	unlock = unlock (obj).
	unlock_with = unlock (obj) 'with' (obj2).
	enter = enter (obj).
	enter = 'get' 'in' (obj).
	climb = climb (obj).
	open_with = open (obj) 'with' (obj2)
		where obj2 isa object
		else "That doesn't even make sense."
	open_with = pry (obj) 'with' (obj2).
	open_with = force (obj) 'with' (obj2).

add to every object
	verb open does "That's not something you can open." end verb.
	verb open_with when obj
		does "That's not something you can open."
	end verb.
	verb close does "That's not something you can close." end verb.
	verb lock does "That's not something you can lock." end verb.
	verb lock_with
		when obj does "That's not something you can lock."
	end verb.
	verb unlock does "That's not something you can unlock." end verb.
	verb unlock_with
		when obj does "That's not something you can unlock."
	end verb.
	verb enter does "That's not something you can enter." end verb.
	verb climb does "That's not something you can climb." end verb.
end add to.

-- Doors *must* come in pairs, or else you need to override 'enter'.
every door isa object
	is not open.
	is locked.
	is not with_known_key.
	has key object.
	has otherside door.
	verb examine does after
		"It's "
		if this is open then "open" else "closed" end if.
		"and "
		if this is locked then "locked" else "unlocked" end if.
		"."
	end verb.
	verb open
		check this is not open
			else say the this. " is already open."
		and this is not locked
			else say the this. " is locked."
		does only
			make this open.
			make otherside of this open.
			"You open " say the this. "."
	end verb.
	verb close
		check this is open
			else say the this. " is already closed."
		and this is not locked
			else say the this. " is locked."
		does only
			make this not open.
			make otherside of this not open.
			"You close " say the this. "."
	end verb.
	verb lock
		check this is not locked
			else say the this. "is already locked."
		and this is with_known_key
			else "You're not sure what to lock "
				say the this. "with."
		does only
			if key of this here then
				if this is open then
					make this not open.
					make otherside of this not open.
					"(first closing " say the this. ")"
				end if.
				make this locked.
				make otherside of this locked.
				"You lock " say the this.
				"with " say the key of this. "."
			else
				"You don't have the key."
			end if.
	end verb.
	verb lock_with when obj
		check this is not locked
			else say the this. " is already locked."
		and obj2 = key of this
			else say the obj2. " doesn't seem to fit the lock."
		does only
			make this with_known_key.
			if this is open then
				make this not open.
				make otherside of this not open.
				"(first closing " say the this. ")"
			end if.
			make this locked.
			make otherside of this locked.
			"You lock " say the this.
			"with " say the key of this. "."
	end verb.
	verb unlock
		check this is locked
			else say the this. "is already unlocked."
		and this is with_known_key
			else "You're not sure what to unlock "
				say the this. "with."
		does only
			if key of this here then
				make this not locked.
				make otherside of this not locked.
				"You unlock " say the this.
				"with " say the key of this. "."
			else
				"You don't have the key."
			end if.
	end verb.
	verb unlock_with when obj
		check this is locked
			else say the this. "is already unlocked."
		and obj2 = key of this
			else say the obj2. "doesn't seem to fit the lock."
		does only
			make this with_known_key.
			make this not locked.
			make otherside of this not locked.
			"You unlock " say the this.
			"with " say the key of this. "."
	end verb.
	verb enter
		check this is not locked
			else say the this. "is locked."
		does only
			if this is not open then
				make this open.
				make otherside of this open.
				"(first opening " say the this. ")"
			end if.
			locate current actor at otherside of this.
	end verb.
	verb open_with when obj does only
		if this is locked then
			"You probably want to unlock" say the this. "instead."
		else
			"You don't need the" say the obj2.
			"to open the" say the this. "."
		end if.
	end verb.
end every.

-- Devices

syntax turn_on = 'turn' 'on' (obj).
	-- turn_on = 'turn' (obj) 'on'.
	turn_off = 'turn' 'off' (obj).
	-- turn_off = 'turn' (obj) 'off'.
	toggle = 'toggle' (obj).
	toggle = 'switch' (obj).
	flip = 'flip' (obj).
	
add to every object
	verb turn_on does "That's not something you can turn on." end verb.
	verb turn_off does "That's not something you can turn off." end verb.
	verb toggle does "That's not something you can toggle." end verb.
	verb flip does "That's not something you can flip." end verb.
end add to.

every device isa object
	is not turned_on.
	is not broken.
	has broken_msg "It appears to be broken.".
	verb examine does after
		"It's currently "
		if this is turned_on then "on" else "off" end if.
		"."
	end verb.
	verb turn_on
		check this is not turned_on
			else say the this. "is already on."
		does only
			if this is broken then
				say broken_msg of this.
			else
				make this turned_on.
				"You turn on " say the this. "."
			end if.
	end verb.
	verb turn_off
		check this is turned_on
			else say the this. "is already off."
		does only
			if this is broken then
				say broken_msg of this.
			else
				make this not turned_on.
				"You turn off " say the this. "."
			end if.
	end verb.
	verb toggle, flip does only
		if this is broken then
			say broken_msg of this.
		else
			"You toggle " say the this. ", turning it"
			if this is turned_on then
				make this not turned_on.
				"off."
			else
				make this turned_on.
				"on."
			end if.
		end if.
	end verb.
end every.
