"ATTACK Test Dungeon" by "Victor Gijsbers"

Include Plurality by Emily Short.
Include Dice-lock by S John Ross.
Include Inform ATTACK by Victor Gijsbers.


When play begins: say "This game is meant as a worked example of Inform ATTACK, and should be studied together with the manual. (So this is not a stand-alone game. It is also not a polished game aimed at persuading you that tactical combat can enrich a work of IF.) By the way, remember the NUMBERS ON command."


Chapter - Second test game		
		
Cave is a room. [The player is in the cave.]
The health of the player is 20.

A mace is a kind of weapon.

The unwieldy mace is a mace. The weapon attack bonus of the unwieldy mace is -1. The unwieldy mace is readied. The player carries the unwieldy mace.

The goblin is in the cave. The goblin is hostile.
The goblin carries a mace called the goblin's mace. The melee of the goblin is -1.

A fatal flavour rule (this is the fatal goblin rule):
	if the global defender is the goblin:
		say "[if the global attacker weapon is a mace]With a sweeping blow, [possessive of the global attacker] mace smashes into the goblin's head[otherwise][The global attacker] land[s] a furious blow on the goblin's head[end if], ending its beastly existence. Wow! A kill! You feel powerful.[run paragraph on]";
		rule succeeds.

A fatal player flavour rule (this is the fatal player goblin rule):
	if the global attacker is the goblin:
		say "Impossible! You stare in disbelief as the goblin[if the global attacker weapon is a mace]'s mace moves towards your face, unstoppable and unstopped[otherwise] hits you square between the eyes[end if], ending all your dreams of fame and treasure.[paragraph break]Killed by the first goblin in the first room of the dungeon. If only you had listened to your mother.";
		rule succeeds.

An attack move flavour rule (this is the goblin attacks rule):
	if the global attacker is the goblin:
		say "[one of]The[or]Smiling wickedly, the[or]With a scream, the[or]Just when you notice your shoe laces are untied, the[as decreasingly likely outcomes] goblin [one of]jumps forward to attack[or]attacks[or]advances towards[at random] [the global defender].";
		rule succeeds.

A flavour rule (this is the goblin defender flavour rule):			
	if the global defender is the goblin and the global attacker is the player:
		if the final damage is greater than 0:
			say "You score a [if the final damage is greater than 3]brilliant [end if]hit against the goblin[if the final damage is greater than 2], who screams in pain[end if]![run paragraph on]";
			rule succeeds;
		otherwise:
			say "[if the goblin is at dodge]The goblin dances out of the way of your clumsy blow[otherwise if the goblin is at parry]The goblin stops your attack with his weapon[otherwise]You attack, but... a miss! How unseemly[end if].[run paragraph on]";
			rule succeeds.
			
A flavour rule (this is the goblin attacker flavour rule):
	if the global attacker is the goblin:
		if the final damage is greater than 0:
			say "The horrible little creature manages to hit you [one of]in the stomach, sending you reeling[or]on your left leg[or]on your behind when you try a fancy Star Wars move[at random].[run paragraph on]";
			rule succeeds;
		otherwise:
			say "[if the player is at dodge]You easily avoid the goblin's flimsy attacks[otherwise if the player is at parry]Clang! You sweep away your enemy's attack and move in for the kill[otherwise]'You'll never get me, hellspawn!', you cry as the yellow demon unsuccessfully attempts to end your life[end if].[run paragraph on]";
			rule succeeds.
			
Report an actor parrying (this is the do not report goblin parry rule):
	if the actor is the goblin:
		rule succeeds.

Report an actor dodging (this is the do not report goblin dodge rule):
	if the actor is the goblin:
		rule succeeds.

Report an actor concentrating (this is the goblin concentrating prose rule):
	if the actor is the goblin:
		now the global actor is the actor;
		if the concentration of the actor is 1, say "The goblin starts chanting in a low voice.";
		if the concentration of the actor is 2, say "The goblin's chant rises in volume[one of]--he sounds like a shaman you once saw on Discovery[or][stopping].";
		if the concentration of the actor is 3, say "The goblin's entrancing song rises to a feverish pitch; his eyes shine with demonic purpose.";
		rule succeeds.				

Lose concentration prose rule (this is the goblin lose concentration prose rule):
	if the concentration loser is the goblin:
		say " The goblin's [bold type]trance[roman type] is broken![run paragraph on]";
		rule succeeds.


Every turn (this is the player death rule):
	if the player is killed:
		end the game saying "You were killed by [the global attacker].".

When play begins:
	now the numbers boolean is false.
	

Section - Retreat
	
Small cavern is north of cave.

Before going (this is the cannot go when in a fight rule):
	if hate is present:
		take no time;
		say "You cannot abandon a fight so easily!" instead.



Grassy meadow is a room. "The cave gapes to the north."
The player is in grassy meadow.
Cave is north of grassy meadow.

Retreating is an action applying to nothing.
Understand "retreat" and "flee" as retreating.

A person is either retreater or not retreater. A person is usually not retreater.

The retreat location is a room that varies. The retreat location is Grassy meadow.

First carry out going (this is the set retreat location rule):
	now the retreat location is the location.

Check retreating (this is the cannot retreat when in the retreat location rule):
	if the retreat location is the location:
		take no time;
		say "You cannot retreat now." instead.
		
Check retreating (this is the cannot retreat when there are no enemies rule):
	if not hate is present:
		say "There's nothing here to retreat from." instead.
		
Check retreating (this is the cannot retreat as reaction rule):
	if the combat state of the player is not at-Act:
		take no time;
		say "You cannot retreat as a reaction--try to survive and run away on your own turn." instead.
	
Carry out retreating (this is the standard carry out retreat rule):
	say "Deciding that discretion is the better part of valour, you bravely run away.";
	now the player is retreater;
	repeat with X running through alive persons in the location:
		if the player is alive:
			if X presses the player or the player presses X:
				now X does not press the player;
				now the player does not press X;
				if the faction of X hates the faction of the player:
					make X strike a blow against the player;
	if the player is alive, move the player to the retreat location;
	now the player is not retreater.


The boots of expeditious retreat are in grassy meadow. They are wearable and plural-named. The indefinite article is "the".

An attack modifiers rule (this is the boots of expeditious retreat grant better retreat rule):
	if the global defender is the player and the player is retreater:
		if the player wears the boots of expeditious retreat:
			if the numbers boolean is true, say " - 2 (boots of expeditious retreat)[run paragraph on]";
			decrease the to-hit modifier by 2.

Section - Frog warriors

A frog warrior is a kind of person.
A frog warrior is usually hostile.
The health of a frog warrior is usually 4.
The melee of a frog warrior is usually -2.
The defence of a frog warrior is usually 7.

A small frog spear is a kind of weapon.
Every frog warrior carries a small frog spear.
The damage die of a small frog spear is usually 2.

A frog warrior called the frog commander is in the Small cavern.
A frog warrior called the limping frog warrior is in the Small cavern.
A frog warrior called the stout frog warrior is in the Small cavern.
A frog warrior called the old frog warrior is in the Small cavern.
A frog warrior called the bright green frog warrior is in the Small cavern.

Standard AI weapon select rule (this is the frogs use spears rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is a small frog spear:
		if the global attacker is a frog warrior:
			increase the Weight entry by 100.
			
Standard AI action select rule (this is the frogs love concentrating rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	if the global attacker is a frog warrior:
		increase the Weight entry by 5.

Section - Shout

Shouting is an action applying to nothing.
Understand "shout" as shouting.

The shout-victims is a list of persons that varies.

Carry out shouting (this is the standard shouting rule):
	now the concentration of the player is 0;
	truncate shout-victims to 0 entries;
	repeat with X running through alive persons enclosed by the location:
		if the concentration of X is not 0:
			if a random chance of 1 in 2 succeeds:
				now the concentration of X is 0;
				add X to shout-victims;
	say "'[one of]BWAAH[or]BLEH[or]GRAAH[or]WRUGH[at random]!', you shout as loudly as you can. [if the number of entries in shout-victims is 0]Unfortunately, nobody is very impressed[otherwise if the number of entries in shout-victims is 1]This startles [shout-victims with definite articles] so much that [it-they] lose[s] concentration[otherwise]This startles [shout-victims with definite articles] so much that they lose concentration[end if].".	


Section - Healing

The shrine is in Grassy meadow. It is fixed in place.

Instead of examining the shrine:
	say "If you pray in this location, the world's wounds will be healed.".

Praying is an action applying to nothing.
Understand "pray" as praying.

Carry out praying (this is the pray in grassy meadow rule):
	if the location is the Grassy Meadow:
		say "God's blessing descends onto the world, healing friend and foe alike.";
		repeat with X running through alive persons:
			fully heal X;
		rule succeeds.

Last carry out praying (this is the pray somewhere else rule):
	say "Words without thoughts never to heaven go.".


A health potion is a kind of thing.

Instead of drinking a health potion:
	heal the player for 6 health;
	say "You drink the health potion, [if the healed amount is 0]but you were already at full health[otherwise if the health of the player is less than the permanent health of the player]partially restoring your health[otherwise]restoring your health[end if].";
	if the combat state of the player is at-React:
		now the player is adrinking.

The player carries 3 health potions.

A person can be either adrinking or not adrinking. A person is usually not adrinking.

An attack modifiers rule (this is the drinking is not a good defence rule):
	if the global defender is adrinking:
		if the numbers boolean is true, say " + 2 (defender drinking a potion)[run paragraph on]";
		increase the to-hit modifier by 2.	

A take away until attack circumstances rule (this is the defender no longer adrinking rule):
	now the global defender is not adrinking.

Include Basic Screen Effects by Emily Short.

Table of Fancy Status
left	central	right
"[bold type][location of the player][roman type]"	"Tension: [tension]"	"Score: [score]/100"
"You [harm status], and armed with [a random readied weapon enclosed by the player]."	""	""

Rule for constructing the status line:
	fill status bar with Table of Fancy Status;
	rule succeeds. 

To say harm status:
	if the numbers boolean is false:
		say "are ";
		let n be 10 times the health of the player;
		now n is n divided by the permanent health of the player;
		if n is:
			-- 10: say "unharmed";
			-- 9: say "scratched";
			-- 8: say "lightly wounded";
			-- 7: say "wounded";
			-- 6: say "wounded";
			-- 5: say "severely wounded";
			-- 4: say "severely wounded";
			-- 3: say "[bold type]bleeding copiously[roman type]";
			-- 2: say "[bold type]losing limbs[roman type]";
			-- otherwise: say "[bold type]dying[roman type]";
	otherwise:
		say "are at [health of the player] of [permanent health of the player] health".

Section - A blade in the dark

The treasure chest is in small cavern. It is fixed in place, container, closed and openable.

Check opening the treasure chest (this is the cannot open chest in combat rule):
	if hate is present:
		take no time;
		say "Not in the presence of enemies!" instead.

A dagger is a kind of weapon.

The damage die of a dagger is usually 2.
The weapon attack bonus of a dagger is usually -2.
The dodgability of a dagger is usually 3.
The passive parry max of a dagger is usually 1.
The active parry max of a dagger is usually 1.

The gilded dagger is a dagger. The gilded dagger is in the treasure chest.

An attack modifiers rule (this is the dagger extra tension attack bonus rule):
	if the global attacker weapon is a dagger:
		let n be 0;
		now n is the tension divided by 2;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (dagger benefits from tension)[run paragraph on]";
			increase the to-hit modifier by n.
		
A damage modifiers rule (this is the dagger extra tension damage bonus rule):
	if the global attacker weapon is a dagger:
		let n be 0;
		now n is the tension divided by 3;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (dagger benefits from tension)[run paragraph on]";
			increase the damage modifier by n.

	
To say tension:
	if the numbers boolean is true:
		say tension;
	otherwise:
		if tension is greater than 15:
			say "very high";
		if tension is greater than 10 and tension is less than 16:
			say "high";
		if tension is greater than 5 and tension is less than 11:
			say "moderate";
		if tension is less than 6:
			say "low".


The cloak of shadows is in the treasure chest. It is wearable.

A person is either shadowed or not shadowed. A person is usually not shadowed.

First standard_attacker rule (this is the do nothing when all enemies shadowed rule):
	let p be false;
	let q be false;
	repeat with X running through all alive persons enclosed by the location:
		if the faction of the global attacker hates the faction of X:
			now p is true;
			if X is not shadowed:
				now q is true;
	if p is true and q is false:
		say "[CAP-attacker] [one of]remains unaware of your presence[or]looks around suspiciously[or]sighs in boredom[as decreasingly likely outcomes].";
		rule succeeds.
	
Every turn when the player wears the cloak of shadows (this is the blend into shadows rule):
	if not hate is present:
		if the player is not shadowed:
			now the player is shadowed;
			say "You blend into the shadows.";

An aftereffects rule (this is the attacking breaks shadowed rule):
	if the global attacker is the player:
		now the player is not shadowed.

The detection probability is a number that varies.
The detection rules are a rulebook.
	
Every turn when the player is shadowed (this is the possible detection rule):	
	if hate is present:
		consider the detection rules;
		let n be a random number between 1 and 100;
		if the detection probability is greater than n:
			now the player is not shadowed;
			say "You have been detected!";
		now the detection probability is 0.


A detection rule (this is the standard probability of detection rule):
	increase the detection probability by 6.
	
A detection rule (this is the tension increases probability of detection rule):
	increase the detection probability by the tension divided by 2.

Check concentrating (this is the cannot concentrate while shadowed rule):
	if the player is shadowed:
		take no time;
		say "You need all your concentration just to stay hidden." instead.

Section - Troll

Troll lair is north of small cavern.

A large troll is in troll lair. The large toll is a person.
The large troll is hostile.

The health of the large troll is 30.
The defence of the large troll is 8.

The large troll carries a huge club.
The huge club is a weapon.
The damage die of the huge club is 10.
The dodgability of the huge club is 5.
The passive parry max of the huge club is 0.
The active parry max of the huge club is 2.

Damage modifiers rule (this is the more damage from club rule):
	if the global attacker weapon is the huge club:
		increase the damage modifier by 3;
		if the numbers boolean is true:
			say " + 3 (huge club)[run paragraph on]".

Check readying the huge club:
	say "It's far too massive for you to use in combat." instead.


An attack modifiers rule (this is the troll attack bonus rule):
	if the global attacker is the large troll:
		let n be a random number between -4 and 10;
		increase the to-hit modifier by n;
		if the numbers boolean is true and n is greater than 0:
			say " + ", n, " (random troll bonus)[run paragraph on]";
		if the numbers boolean is true and n is less than 0:
			say " - ", 0 minus n, " (random troll bonus)[run paragraph on]".

Chance to win rule (this is the troll CTW rule):
	increase the chance-to-win by a random number between -4 and 10.

A standard AI action select rule (this is the troll attack select rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	increase the Weight entry by 2.



Slime-healing is an action applying to nothing.

Carry out the large troll slime-healing:
	say "The troll drools large amounts of slime over its arms, chest and leg. Wherever the slime touches its wounds, they close and apparently heal.";
	heal the large troll for 5 health.

First standard AI action select rule (this is the consider slime-healing rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker slime-healing;
	change the Weight entry to -1000.
		
Standard AI action select rule (this is the only the troll considers slime-healing rule):
	choose row with an Option of the action of the global attacker slime-healing in the Table of AI Combat Options;
	if the global attacker is the large troll:
		change the Weight entry to 15;
		decrease the Weight entry by the health of the large troll.
		
Standard AI action select rule (this is the trolls heals only 20 percent of the time rule):
	choose row with an Option of the action of the global attacker slime-healing in the Table of AI Combat Options;	
	if a random chance of 4 in 5 succeeds, decrease the weight entry by 100;
		
Standard AI action select rule (this is the troll doesnt heal when player almost dead rule):
	choose row with an Option of the action of the global attacker slime-healing in the Table of AI Combat Options;
	if the health of the global defender is less than 8:
		decrease the weight entry by 8 minus the health of the global defender.


Section - Victory

Every turn when in the grassy meadow (this is the victory rule):
	if there are no hostile alive persons:
		end the game saying "You emerge into the sunlight, victorious!".

	
Section - Test commands - Not for release

When play begins, seed the random-number generator with 1081.

Plunking is an action applying to one thing.
Understand "plunk [something]" as plunking.

Carry out plunking:
	say "You plunk [the noun].";
	now the health of the noun is -5.

Plonking is an action applying to nothing.
Understand "plonk" as plonking.

Carry out plonking:
	say "These fools are no match for you, my lord!";
	repeat with X running through all alive persons enclosed by the location:
		if the faction of the player hates the faction of X:
			now the health of X is -5.

Section - Save and undo

Check saving the game (this is the can only save in meadow rule):
	if the location is not the grassy meadow:
		say "You can only save outside, where God can see you." instead.

Include Conditional Undo by Jesse McGrew.

Rule for deciding whether to allow undo (this is the no undoing during a fight rule):
	if hate is present:
		take no time;
		say "You cannot undo during a fight.";
		deny undo.